/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.natives.BadGPU;
import gabien.natives.BadGPUEnum;
import gabien.render.IImage;
import gabien.render.ITexRegion;
import gabien.render.RenderTarget;
import gabien.uslx.append.Block;
import gabien.uslx.append.PrimStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class IGrDriver
extends RenderTarget {
    public final int[] scissor = new int[4];
    public final float[] trs = new float[4];
    private final PrimStack.I32 scissorStack = new PrimStack.I32();
    private final Block scissorStackPopper = () -> this.scissorStack.pop(this.scissor, 0, 4);
    private final PrimStack.F32 trsStack = new PrimStack.F32();
    private final Block trsStackPopper = () -> this.trsStack.pop(this.trs, 0, 4);
    private final Block translateStackPopper = () -> this.trsStack.pop(this.trs, 0, 2);
    public static final int BLEND_NONE = BadGPU.blendProgram(BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.Zero, BadGPUEnum.BlendOp.Add, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.Zero, BadGPUEnum.BlendOp.Add);
    public static final int BLEND_NORMAL = BadGPU.blendProgram(BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.InvertSrcA, BadGPUEnum.BlendOp.Add, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.InvertSrcA, BadGPUEnum.BlendOp.Add);
    public static final int BLEND_ADD = BadGPU.blendProgram(BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendOp.Add, BadGPUEnum.BlendWeight.Zero, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendOp.Add);
    public static final int BLEND_SUB = BadGPU.blendProgram(BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendOp.ReverseSub, BadGPUEnum.BlendWeight.Zero, BadGPUEnum.BlendWeight.One, BadGPUEnum.BlendOp.Add);
    private final int DRAWFLAGS_WRAPST = 12288;

    public IGrDriver(@Nullable String id, int w, int h) {
        super(id, w, h);
        this.trs[2] = 1.0f;
        this.trs[3] = 1.0f;
        this.scissor[2] = w;
        this.scissor[3] = h;
    }

    public abstract void rawBatchXYST(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7, @Nullable ITexRegion var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20);

    public abstract void rawBatchXYST(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7, @Nullable ITexRegion var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24);

    public abstract void rawBatchXYSTRGBA(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7, @Nullable ITexRegion var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25, float var26, float var27, float var28, float var29, float var30, float var31, float var32);

    public abstract void rawBatchXYSTRGBA(boolean var1, int var2, int var3, int var4, int var5, int var6, int var7, @Nullable ITexRegion var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23, float var24, float var25, float var26, float var27, float var28, float var29, float var30, float var31, float var32, float var33, float var34, float var35, float var36, float var37, float var38, float var39, float var40);

    public final void clearAndCycleTransformAndScissorStacks() {
        this.scissorStack.cycle();
        this.scissorStack.clear();
        this.trsStack.cycle();
        this.trsStack.clear();
    }

    protected final float trsX(float x) {
        return this.trs[0] + x * this.trs[2];
    }

    protected final float trsY(float y) {
        return this.trs[1] + y * this.trs[3];
    }

    public final synchronized void drawXYST(int blendMode, int drawFlagsEx, @Nullable ITexRegion tex, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2) {
        x0 = this.trsX(x0);
        y0 = this.trsY(y0);
        x1 = this.trsX(x1);
        y1 = this.trsY(y1);
        x2 = this.trsX(x2);
        y2 = this.trsY(y2);
        this.rawBatchXYST(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, drawFlagsEx, tex, x0, y0, s0, t0, x1, y1, s1, t1, x2, y2, s2, t2);
    }

    public final synchronized void drawXYST(int blendMode, int drawFlagsEx, @Nullable ITexRegion tex, float x0, float y0, float s0, float t0, float x1, float y1, float s1, float t1, float x2, float y2, float s2, float t2, float x3, float y3, float s3, float t3) {
        x0 = this.trsX(x0);
        y0 = this.trsY(y0);
        x1 = this.trsX(x1);
        y1 = this.trsY(y1);
        x2 = this.trsX(x2);
        y2 = this.trsY(y2);
        x3 = this.trsX(x3);
        y3 = this.trsY(y3);
        this.rawBatchXYST(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, drawFlagsEx, tex, x0, y0, s0, t0, x1, y1, s1, t1, x2, y2, s2, t2, x3, y3, s3, t3);
    }

    public final synchronized void drawXYSTRGBA(int blendMode, int drawFlagsEx, @Nullable ITexRegion tex, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2) {
        x0 = this.trsX(x0);
        y0 = this.trsY(y0);
        x1 = this.trsX(x1);
        y1 = this.trsY(y1);
        x2 = this.trsX(x2);
        y2 = this.trsY(y2);
        this.rawBatchXYSTRGBA(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, drawFlagsEx, tex, x0, y0, s0, t0, r0 *= a0, g0 *= a0, b0 *= a0, a0, x1, y1, s1, t1, r1 *= a1, g1 *= a1, b1 *= a1, a1, x2, y2, s2, t2, r2 *= a2, g2 *= a2, b2 *= a2, a2);
    }

    public final synchronized void drawXYSTRGBA(int blendMode, int drawFlagsEx, @Nullable ITexRegion tex, float x0, float y0, float s0, float t0, float r0, float g0, float b0, float a0, float x1, float y1, float s1, float t1, float r1, float g1, float b1, float a1, float x2, float y2, float s2, float t2, float r2, float g2, float b2, float a2, float x3, float y3, float s3, float t3, float r3, float g3, float b3, float a3) {
        x0 = this.trsX(x0);
        y0 = this.trsY(y0);
        x1 = this.trsX(x1);
        y1 = this.trsY(y1);
        x2 = this.trsX(x2);
        y2 = this.trsY(y2);
        x3 = this.trsX(x3);
        y3 = this.trsY(y3);
        r0 *= a0;
        g0 *= a0;
        this.rawBatchXYSTRGBA(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, drawFlagsEx, tex, x0, y0, s0, t0, r0, g0, b0 *= a0, a0, x1, y1, s1, t1, r1 *= a1, g1 *= a1, b1 *= a1, a1, x2, y2, s2, t2, r2 *= a2, g2 *= a2, b2 *= a2, a2, x3, y3, s3, t3, r3 *= a3, g3 *= a3, b3 *= a3, a3);
    }

    public final void clearAll(int r, int g, int b) {
        this.clearAll(r, g, b, 255);
    }

    public abstract void clearAll(int var1, int var2, int var3, int var4);

    public final synchronized void blitScaledImage(float srcx, float srcy, float srcw, float srch, float x, float y, float w, float h, @Nullable ITexRegion iU, int blendMode, int drawFlagsEx) {
        float cR = this.trsX(x + w);
        float cD = this.trsY(y + h);
        x = this.trsX(x);
        y = this.trsY(y);
        w = cR - x;
        h = cD - y;
        float srcR = srcx + srcw;
        float srcD = srcy + srch;
        int scL = this.scissor[0];
        int scU = this.scissor[1];
        int scR = this.scissor[2];
        int scD = this.scissor[3];
        if (x < (float)scL) {
            srcx += ((float)scL - x) * srcw / w;
            x = scL;
        }
        if (y < (float)scU) {
            srcy += ((float)scU - y) * srch / h;
            y = scU;
        }
        if (cR > (float)scR) {
            srcR -= (cR - (float)scR) * srcw / w;
            cR = scR;
        }
        if (cD > (float)scD) {
            srcD -= (cD - (float)scD) * srch / h;
            cD = scD;
        }
        if (cR <= x || cD <= y) {
            return;
        }
        this.rawBatchXYST(false, scL, scU, scR, scD, blendMode, drawFlagsEx, iU, x, y, srcx, srcy, cR, y, srcR, srcy, cR, cD, srcR, srcD, x, cD, srcx, srcD);
    }

    public final synchronized void drawScaledColoured(float srcx, float srcy, float srcw, float srch, float x, float y, float w, float h, @Nullable ITexRegion iU, int blendMode, int drawFlagsEx, float r, float g, float b, float a) {
        float cR = this.trsX(x + w);
        float cD = this.trsY(y + h);
        x = this.trsX(x);
        y = this.trsY(y);
        w = cR - x;
        h = cD - y;
        float srcR = srcx + srcw;
        float srcD = srcy + srch;
        int scL = this.scissor[0];
        int scU = this.scissor[1];
        int scR = this.scissor[2];
        int scD = this.scissor[3];
        if (x < (float)scL) {
            srcx += ((float)scL - x) * srcw / w;
            x = scL;
        }
        if (y < (float)scU) {
            srcy += ((float)scU - y) * srch / h;
            y = scU;
        }
        if (cR > (float)scR) {
            srcR -= (cR - (float)scR) * srcw / w;
            cR = scR;
        }
        if (cD > (float)scD) {
            srcD -= (cD - (float)scD) * srch / h;
            cD = scD;
        }
        if (cR <= x || cD <= y) {
            return;
        }
        this.rawBatchXYSTRGBA(false, scL, scU, scR, scD, blendMode, drawFlagsEx, iU, x, y, srcx, srcy, r *= a, g *= a, b *= a, a, cR, y, srcR, srcy, r, g, b, a, cR, cD, srcR, srcD, r, g, b, a, x, cD, srcx, srcD, r, g, b, a);
    }

    public final synchronized void drawRotatedScaled(float srcx, float srcy, float srcw, float srch, float x, float y, float acw, float ach, float angle, @Nullable ITexRegion iU, int blendMode, int drawFlagsEx) {
        if (angle == 0.0f) {
            this.blitScaledImage(srcx, srcy, srcw, srch, x, y, acw, ach, iU, blendMode, drawFlagsEx);
            return;
        }
        float srcD = srcy + srch;
        float srcR = srcx + srch;
        double angleInRadians = Math.toRadians(-angle);
        double sin = Math.sin(angleInRadians);
        double cos = Math.cos(angleInRadians);
        float acw2 = acw / 2.0f;
        float ach2 = ach / 2.0f;
        float centreX = this.trsX(x + acw2);
        float centreY = this.trsY(y + ach2);
        float xBasisX = (float)(cos * (double)acw2 * (double)this.trs[2]);
        float xBasisY = (float)(sin * (double)acw2 * (double)this.trs[3]);
        float yBasisX = (float)(-sin * (double)ach2 * (double)this.trs[2]);
        float yBasisY = (float)(cos * (double)ach2 * (double)this.trs[3]);
        float p00X = centreX - (xBasisX + yBasisX);
        float p00Y = centreY - (xBasisY + yBasisY);
        float p10X = centreX + xBasisX - yBasisX;
        float p10Y = centreY + xBasisY - yBasisY;
        float p11X = centreX + xBasisX + yBasisX;
        float p11Y = centreY + xBasisY + yBasisY;
        float p01X = centreX + yBasisX - xBasisX;
        float p01Y = centreY + yBasisY - xBasisY;
        this.rawBatchXYST(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, 0, iU, p00X, p00Y, srcx, srcy, p10X, p10Y, srcR, srcy, p11X, p11Y, srcR, srcD, p01X, p01Y, srcx, srcD);
    }

    public final synchronized void drawRotatedScaledColoured(float srcx, float srcy, float srcw, float srch, float x, float y, float acw, float ach, float angle, @Nullable ITexRegion iU, int blendMode, int drawFlagsEx, float r, float g, float b, float a) {
        if (angle == 0.0f) {
            this.drawScaledColoured(srcx, srcy, srcw, srch, x, y, acw, ach, iU, blendMode, drawFlagsEx, r, g, b, a);
            return;
        }
        float srcD = srcy + srch;
        float srcR = srcx + srch;
        double angleInRadians = Math.toRadians(-angle);
        double sin = Math.sin(angleInRadians);
        double cos = Math.cos(angleInRadians);
        float acw2 = acw / 2.0f;
        float ach2 = ach / 2.0f;
        float centreX = this.trsX(x + acw2);
        float centreY = this.trsY(y + ach2);
        float xBasisX = (float)(cos * (double)acw2 * (double)this.trs[2]);
        float xBasisY = (float)(sin * (double)acw2 * (double)this.trs[3]);
        float yBasisX = (float)(-sin * (double)ach2 * (double)this.trs[2]);
        float yBasisY = (float)(cos * (double)ach2 * (double)this.trs[3]);
        float p00X = centreX - (xBasisX + yBasisX);
        float p00Y = centreY - (xBasisY + yBasisY);
        float p10X = centreX + xBasisX - yBasisX;
        float p10Y = centreY + xBasisY - yBasisY;
        float p11X = centreX + xBasisX + yBasisX;
        float p11Y = centreY + xBasisY + yBasisY;
        float p01X = centreX + yBasisX - xBasisX;
        float p01Y = centreY + yBasisY - xBasisY;
        this.rawBatchXYSTRGBA(true, this.scissor[0], this.scissor[1], this.scissor[2], this.scissor[3], blendMode, 0, iU, p00X, p00Y, srcx, srcy, r *= a, g *= a, b *= a, a, p10X, p10Y, srcR, srcy, r, g, b, a, p11X, p11Y, srcR, srcD, r, g, b, a, p01X, p01Y, srcx, srcD, r, g, b, a);
    }

    public final void blitImage(float srcx, float srcy, float srcw, float srch, float x, float y, @Nullable ITexRegion i) {
        this.blitScaledImage(srcx, srcy, srcw, srch, x, y, srcw, srch, i, BLEND_NORMAL, 0);
    }

    public final void blitImage(float x, float y, @NonNull ITexRegion i) {
        float srcw = i.getRegionWidth();
        float srch = i.getRegionHeight();
        this.blitScaledImage(0.0f, 0.0f, srcw, srch, x, y, srcw, srch, i, BLEND_NORMAL, 0);
    }

    public final void blitImage(float srcx, float srcy, float srcw, float srch, float x, float y, @NonNull ITexRegion i, int blendMode, int drawFlagsEx) {
        this.blitScaledImage(srcx, srcy, srcw, srch, x, y, srcw, srch, i, blendMode, drawFlagsEx);
    }

    public final void blitTiledImage(float x, float y, float w, float h, @Nullable IImage cachedTile) {
        this.blitScaledImage(0.0f, 0.0f, w, h, x, y, w, h, cachedTile, BLEND_NORMAL, 12288);
    }

    public final void blitScaledImage(float srcx, float srcy, float srcw, float srch, float x, float y, float acw, float ach, @Nullable ITexRegion i) {
        this.blitScaledImage(srcx, srcy, srcw, srch, x, y, acw, ach, i, BLEND_NORMAL, 0);
    }

    public final void blitScaledImage(float x, float y, float acw, float ach, @NonNull ITexRegion i) {
        this.blitScaledImage(0.0f, 0.0f, i.getRegionWidth(), i.getRegionHeight(), x, y, acw, ach, i, BLEND_NORMAL, 0);
    }

    public final void blitScaledImage(float x, float y, float acw, float ach, @NonNull ITexRegion i, int blendMode, int drawFlagsEx) {
        this.blitScaledImage(0.0f, 0.0f, i.getRegionWidth(), i.getRegionHeight(), x, y, acw, ach, i, blendMode, drawFlagsEx);
    }

    public final void drawRotatedScaled(float srcx, float srcy, float srcw, float srch, float x, float y, float acw, float ach, float angle, @Nullable ITexRegion i) {
        this.drawRotatedScaled(srcx, srcy, srcw, srch, x, y, acw, ach, angle, i, BLEND_NORMAL, 0);
    }

    public final void drawRotatedScaled(float x, float y, float acw, float ach, float angle, @NonNull ITexRegion i, int blendMode, int drawFlagsEx) {
        float srcw = i.getRegionWidth();
        float srch = i.getRegionHeight();
        this.drawRotatedScaled(0.0f, 0.0f, srcw, srch, x, y, acw, ach, angle, i, blendMode, drawFlagsEx);
    }

    public final void drawRotatedScaled(float x, float y, float acw, float ach, float angle, @NonNull ITexRegion i) {
        float srcw = i.getRegionWidth();
        float srch = i.getRegionHeight();
        this.drawRotatedScaled(0.0f, 0.0f, srcw, srch, x, y, acw, ach, angle, i, BLEND_NORMAL, 0);
    }

    public final void drawScaledColoured(float srcx, float srcy, float srcw, float srch, float x, float y, float w, float h, @Nullable ITexRegion iU, float r, float g, float b, float a) {
        this.drawScaledColoured(srcx, srcy, srcw, srch, x, y, w, h, iU, BLEND_NORMAL, 0, r, g, b, a);
    }

    public final void clearRect(int r, int g, int b, float x, float y, float width, float height) {
        this.drawScaledColoured(0.0f, 0.0f, 0.0f, 0.0f, x, y, width, height, null, BLEND_NONE, 0, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public final void fillRect(int r, int g, int b, int a, float x, float y, float w, float h) {
        this.drawScaledColoured(0.0f, 0.0f, 0.0f, 0.0f, x, y, w, h, null, a == 255 ? BLEND_NONE : BLEND_NORMAL, 0, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public final Block openTRS(float tx, float ty, float sx, float sy) {
        this.trsStack.push(this.trs, 0, 4);
        this.trs[0] = this.trs[0] + tx * this.trs[2];
        this.trs[1] = this.trs[1] + ty * this.trs[3];
        this.trs[2] = this.trs[2] * sx;
        this.trs[3] = this.trs[3] * sy;
        return this.trsStackPopper;
    }

    public final Block openTranslate(float tx, float ty) {
        this.trsStack.push(this.trs, 0, 2);
        this.trs[0] = this.trs[0] + tx * this.trs[2];
        this.trs[1] = this.trs[1] + ty * this.trs[3];
        return this.translateStackPopper;
    }

    public final Block openScissor(float x, float y, float w, float h) {
        float left = x;
        float top = y;
        float right = left + w;
        float bottom = top + h;
        float osTX = this.trs[0];
        float osTY = this.trs[1];
        float osSX = this.trs[2];
        float osSY = this.trs[3];
        int osLeft = this.scissor[0];
        int osTop = this.scissor[1];
        int osRight = this.scissor[2];
        int osBottom = this.scissor[3];
        float scaledX = x * osSX;
        float scaledY = y * osSY;
        int leftI = Math.max((int)(osTX + scaledX), osLeft);
        int topI = Math.max((int)(osTY + scaledY), osTop);
        int rightI = Math.min((int)(osTX + right * osSX), osRight);
        int bottomI = Math.min((int)(osTY + bottom * osSY), osBottom);
        this.scissorStack.push(this.scissor, 0, 4);
        this.scissor[0] = leftI;
        this.scissor[1] = topI;
        this.scissor[2] = Math.max(leftI, rightI);
        this.scissor[3] = Math.max(topI, bottomI);
        return this.scissorStackPopper;
    }
}

