/*
 * Decompiled with CFR 0.152.
 */
package gabien.render;

import gabien.render.IDrawable;
import gabien.render.IGrDriver;
import org.eclipse.jdt.annotation.NonNull;

public class DrawableRegion
implements IDrawable {
    public final IDrawable parent;
    public final float regX;
    public final float regY;
    public final float regWidth;
    public final float regHeight;
    private final float ofsX;
    private final float ofsY;
    private final float widthMul;
    private final float heightMul;
    private final float parentWidth;
    private final float parentHeight;

    public DrawableRegion(IDrawable parent, float x, float y, float width, float height) {
        this.parent = parent;
        this.regX = x;
        this.regY = y;
        this.regWidth = width;
        this.regHeight = height;
        this.parentWidth = parent.getRegionWidth();
        this.parentHeight = parent.getRegionHeight();
        this.widthMul = this.parentWidth / width;
        this.heightMul = this.parentHeight / height;
        this.ofsX = -x / this.parentWidth;
        this.ofsY = -y / this.parentHeight;
    }

    @Override
    public float getRegionWidth() {
        return this.regWidth;
    }

    @Override
    public float getRegionHeight() {
        return this.regHeight;
    }

    @Override
    public void drawTo(float x, float y, float w, float h, IGrDriver target) {
        this.parent.drawTo(x += this.ofsX * (w *= this.widthMul), y += this.ofsY * (h *= this.heightMul), w, h, target);
    }

    @Override
    @NonNull
    public IDrawable subRegion(float x, float y, float w, float h) {
        return new DrawableRegion(this.parent, this.regX + x, this.regY + y, w, h);
    }
}

