/*
 * Decompiled with CFR 0.152.
 */
package gabien.pva;

import gabien.GaBIEn;
import gabien.natives.BadGPUEnum;
import gabien.pva.PVAFile;
import gabien.render.IGrDriver;
import gabien.uslx.append.Block;
import gabien.vopeks.VopeksImage;
import java.io.IOException;
import java.io.InputStream;

public class PVARenderer {
    public final PVAFile pvaFile;
    public final VopeksImage[] images;

    public PVARenderer(InputStream inp) throws IOException {
        this(new PVAFile(inp, false));
    }

    public PVARenderer(PVAFile pva) {
        this.pvaFile = pva;
        this.images = new VopeksImage[pva.imageHeaders.length];
        for (int i = 0; i < this.images.length; ++i) {
            this.images[i] = new VopeksImage(GaBIEn.vopeks, "PVAImage" + i, pva.imageHeaders[i].w, pva.imageHeaders[i].h, BadGPUEnum.TextureLoadFormat.RGBA8888_SA, pva.imageDatas[i]);
        }
    }

    public void renderInline(PVAFile.FrameElm[] frame, IGrDriver driver, float x, float y, float width, float height) {
        float wd2 = width / 2.0f;
        float hd2 = height / 2.0f;
        try (Block b = driver.openTRS(x + wd2, y + hd2, wd2, hd2);){
            for (PVAFile.FrameElm fe : frame) {
                float w2;
                float w1;
                PVAFile.Matrix mtx = this.pvaFile.matrices[fe.mtxIndex];
                PVAFile.Triangle tri = this.pvaFile.triangles[fe.triIndex];
                PVAFile.Loop loopA = this.pvaFile.loops[tri.aIndex];
                PVAFile.Loop loopB = this.pvaFile.loops[tri.bIndex];
                PVAFile.Loop loopC = this.pvaFile.loops[tri.cIndex];
                PVAFile.Vertex vA = this.pvaFile.vertices[loopA.vtxIndex];
                PVAFile.Vertex vB = this.pvaFile.vertices[loopB.vtxIndex];
                PVAFile.Vertex vC = this.pvaFile.vertices[loopC.vtxIndex];
                float w0 = mtx.transformVertexW(vA);
                if (w0 <= 0.0f) continue;
                float x0 = mtx.transformVertexX(vA) / w0;
                float y0 = mtx.transformVertexY(vA) / w0;
                float z0 = mtx.transformVertexZ(vA) / w0;
                if (z0 < -1.0f || (w1 = mtx.transformVertexW(vB)) <= 0.0f) continue;
                float x1 = mtx.transformVertexX(vB) / w1;
                float y1 = mtx.transformVertexY(vB) / w1;
                float z1 = mtx.transformVertexZ(vB) / w1;
                if (z1 < -1.0f || (w2 = mtx.transformVertexW(vC)) <= 0.0f) continue;
                float x2 = mtx.transformVertexX(vC) / w2;
                float y2 = mtx.transformVertexY(vC) / w2;
                float z2 = mtx.transformVertexZ(vC) / w2;
                if (z2 < -1.0f) continue;
                PVAFile.PaletteElm pA = this.pvaFile.palette[loopA.palIndex];
                PVAFile.PaletteElm pB = this.pvaFile.palette[loopB.palIndex];
                PVAFile.PaletteElm pC = this.pvaFile.palette[loopC.palIndex];
                VopeksImage img = null;
                int blendMode = IGrDriver.BLEND_NORMAL;
                int drawFlagsEx = 0;
                float sM = 1.0f;
                float tM = 1.0f;
                if (tri.texIndex != -1) {
                    PVAFile.Texture tex = this.pvaFile.textures[tri.texIndex];
                    img = this.images[tex.imgIndex];
                    if ((tex.mode & 1) != 0) {
                        drawFlagsEx |= 0x600;
                    }
                    if ((tex.mode & 2) != 0) {
                        drawFlagsEx |= 0x3000;
                    }
                    sM *= (float)img.width;
                    tM *= (float)img.height;
                }
                driver.drawXYSTRGBA(blendMode, drawFlagsEx, img, x0, -y0, loopA.u * sM, loopA.v * tM, pA.r, pA.g, pA.b, pA.a, x1, -y1, loopB.u * sM, loopB.v * tM, pB.r, pB.g, pB.b, pB.a, x2, -y2, loopC.u * sM, loopC.v * tM, pC.r, pC.g, pC.b, pC.a);
            }
        }
    }
}

