/*
 * Decompiled with CFR 0.152.
 */
package gabien.pva;

import gabien.pva.PVAFile;
import gabien.pva.PVARenderer;
import gabien.render.IDrawable;
import gabien.render.IGrDriver;
import gabien.ui.theming.IIcon;

public class PVAFrameDrawable
implements IDrawable,
IIcon {
    public final PVARenderer renderer;
    public final PVAFile.FrameElm[] frameData;

    public PVAFrameDrawable(PVARenderer renderer, int frameIdx) {
        this(renderer, renderer.pvaFile.frames[frameIdx]);
    }

    public PVAFrameDrawable(PVARenderer renderer, PVAFile.FrameElm[] frameData) {
        this.renderer = renderer;
        this.frameData = frameData;
    }

    @Override
    public float getRegionWidth() {
        return this.renderer.pvaFile.header.width;
    }

    @Override
    public float getRegionHeight() {
        return this.renderer.pvaFile.header.height;
    }

    @Override
    public void drawTo(float x, float y, float w, float h, IGrDriver target) {
        this.renderer.renderInline(this.frameData, target, x, y, w, h);
    }

    @Override
    public void draw(IGrDriver igd, int x, int y, int size) {
        this.renderer.renderInline(this.frameData, igd, x, y, size, size);
    }
}

