/*
 * Decompiled with CFR 0.152.
 */
package gabien.pva;

import gabien.pva.CABS;
import gabien.uslx.append.MathsX;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;

public class PVAFile {
    public final Header header = new Header();
    public final SequenceElm[] sequence;
    public final FrameElm[][] frames;
    public final Triangle[] triangles;
    public final Matrix[] matrices;
    public final Loop[] loops;
    public final PaletteElm[] palette;
    public final Vertex[] vertices;
    public final Texture[] textures;
    public final ImageHeader[] imageHeaders;
    public final byte[][] imageDatas;
    public final double duration;

    public PVAFile(InputStream inp, boolean decompressed) throws IOException {
        if (!decompressed) {
            inp = new InflaterInputStream(inp);
        }
        this.header.read(CABS.readChunk(inp));
        this.sequence = new SequenceElm().readArray(CABS.readChunk(inp)).toArray(new SequenceElm[0]);
        this.frames = new FrameElm[this.header.frameCount][];
        for (int i = 0; i < this.header.frameCount; ++i) {
            this.frames[i] = new FrameElm().readArray(CABS.readChunk(inp)).toArray(new FrameElm[0]);
        }
        this.triangles = new Triangle().readArray(CABS.readChunk(inp)).toArray(new Triangle[0]);
        this.matrices = new Matrix().readArray(CABS.readChunk(inp)).toArray(new Matrix[0]);
        this.loops = new Loop().readArray(CABS.readChunk(inp)).toArray(new Loop[0]);
        this.palette = new PaletteElm().readArray(CABS.readChunk(inp)).toArray(new PaletteElm[0]);
        this.vertices = new Vertex().readArray(CABS.readChunk(inp)).toArray(new Vertex[0]);
        this.textures = new Texture().readArray(CABS.readChunk(inp)).toArray(new Texture[0]);
        this.imageHeaders = new ImageHeader().readArray(CABS.readChunk(inp)).toArray(new ImageHeader[0]);
        this.imageDatas = new byte[this.imageHeaders.length][];
        int imgCount = this.imageHeaders.length;
        for (int i = 0; i < imgCount; ++i) {
            this.imageDatas[i] = CABS.readChunk(inp);
        }
        double total = 0.0;
        for (SequenceElm se : this.sequence) {
            total += (double)se.delay;
        }
        this.duration = total;
    }

    public int frameOf(double time) {
        double frameStartTime = 0.0;
        for (SequenceElm se : this.sequence) {
            double frameEndTime = frameStartTime + (double)se.delay;
            if (time < frameEndTime) {
                return se.frameIndex;
            }
            frameStartTime = frameEndTime;
        }
        return -1;
    }

    public int frameOfClamped(double time) {
        int res = this.frameOf(time);
        if (res == -1 && this.sequence.length > 0) {
            return this.sequence[this.sequence.length - 1].frameIndex;
        }
        return res;
    }

    public int frameOfLooped(double time) {
        return this.frameOfClamped(MathsX.seqModulo(time, this.duration));
    }

    public static final class ImageHeader
    extends Struct<ImageHeader> {
        public int w;
        public int h;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.w = inp.getInt(at);
            this.h = inp.getInt(at + 4);
            return 8;
        }

        @Override
        public ImageHeader make() {
            return new ImageHeader();
        }
    }

    public static final class Texture
    extends Struct<Texture> {
        public static final int MODE_FILTER = 1;
        public static final int MODE_REPEAT = 2;
        public int mode;
        public int imgIndex;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.mode = inp.getInt(at);
            this.imgIndex = inp.getInt(at + 4);
            return 8;
        }

        @Override
        public Texture make() {
            return new Texture();
        }
    }

    public static final class Vertex
    extends Struct<Vertex> {
        public float x;
        public float y;
        public float z;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.x = inp.getFloat(at);
            this.y = inp.getFloat(at + 4);
            this.z = inp.getFloat(at + 8);
            return 12;
        }

        @Override
        public Vertex make() {
            return new Vertex();
        }
    }

    public static final class PaletteElm
    extends Struct<PaletteElm> {
        public float r;
        public float g;
        public float b;
        public float a;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.r = (float)(inp.getShort(at) & 0xFFFF) / 255.0f;
            this.g = (float)(inp.getShort(at + 2) & 0xFFFF) / 255.0f;
            this.b = (float)(inp.getShort(at + 4) & 0xFFFF) / 255.0f;
            this.a = (float)(inp.get(at + 6) & 0xFF) / 255.0f;
            return 7;
        }

        @Override
        public PaletteElm make() {
            return new PaletteElm();
        }
    }

    public static final class Loop
    extends Struct<Loop> {
        public int vtxIndex;
        public int palIndex;
        public float u;
        public float v;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.vtxIndex = inp.getInt(at);
            this.palIndex = inp.getInt(at + 4);
            this.u = inp.getFloat(at + 8);
            this.v = inp.getFloat(at + 12);
            return 16;
        }

        @Override
        public Loop make() {
            return new Loop();
        }
    }

    public static final class Matrix
    extends Struct<Matrix> {
        public float[] content = new float[16];

        @Override
        public int read(ByteBuffer inp, int at) {
            for (int i = 0; i < 16; ++i) {
                this.content[i] = inp.getFloat(at);
                at += 4;
            }
            return 64;
        }

        @Override
        public Matrix make() {
            return new Matrix();
        }

        public float transformVertexX(Vertex vtx) {
            return vtx.x * this.content[0] + vtx.y * this.content[1] + vtx.z * this.content[2] + this.content[3];
        }

        public float transformVertexY(Vertex vtx) {
            return vtx.x * this.content[4] + vtx.y * this.content[5] + vtx.z * this.content[6] + this.content[7];
        }

        public float transformVertexZ(Vertex vtx) {
            return vtx.x * this.content[8] + vtx.y * this.content[9] + vtx.z * this.content[10] + this.content[11];
        }

        public float transformVertexW(Vertex vtx) {
            return vtx.x * this.content[12] + vtx.y * this.content[13] + vtx.z * this.content[14] + this.content[15];
        }
    }

    public static final class Triangle
    extends Struct<Triangle> {
        public int texIndex;
        public int aIndex;
        public int bIndex;
        public int cIndex;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.texIndex = inp.getInt(at);
            this.aIndex = inp.getInt(at + 4);
            this.bIndex = inp.getInt(at + 8);
            this.cIndex = inp.getInt(at + 12);
            return 16;
        }

        @Override
        public Triangle make() {
            return new Triangle();
        }
    }

    public static final class FrameElm
    extends Struct<FrameElm> {
        public int mtxIndex;
        public int triIndex;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.mtxIndex = inp.getInt(at);
            this.triIndex = inp.getInt(at + 4);
            return 8;
        }

        @Override
        public FrameElm make() {
            return new FrameElm();
        }
    }

    public static final class SequenceElm
    extends Struct<SequenceElm> {
        public float delay;
        public int frameIndex;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.delay = inp.getFloat(at);
            this.frameIndex = inp.getInt(at + 4);
            return 8;
        }

        @Override
        public SequenceElm make() {
            return new SequenceElm();
        }
    }

    public static final class Header
    extends Struct<Header> {
        public int width;
        public int height;
        public int frameCount;

        @Override
        public int read(ByteBuffer inp, int at) {
            this.width = inp.getInt(at);
            this.height = inp.getInt(at + 4);
            this.frameCount = inp.getInt(at + 8);
            return 12;
        }

        @Override
        public Header make() {
            return new Header();
        }
    }

    public static abstract class Struct<T extends Struct<T>> {
        public final void read(byte[] src) {
            ByteBuffer bb = ByteBuffer.wrap(src);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            this.read(bb, 0);
        }

        public abstract int read(ByteBuffer var1, int var2);

        public abstract T make();

        public final ArrayList<T> readArray(byte[] src) {
            T tgt;
            ArrayList<T> list = new ArrayList<T>();
            if (src.length == 0) {
                return list;
            }
            ByteBuffer bb = ByteBuffer.wrap(src);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int at = 0; at < src.length; at += ((Struct)tgt).read(bb, at)) {
                tgt = this.make();
                list.add(tgt);
            }
            return list;
        }
    }
}

