/*
 * Decompiled with CFR 0.152.
 */
package gabien.natives;

import gabien.natives.InvalidatedPointerException;
import gabien.natives.VorbisEnum;
import gabien.natives.VorbisUnsafe;
import java.util.concurrent.atomic.AtomicBoolean;

public final class VorbisDecoder
extends VorbisEnum
implements AutoCloseable {
    private final long instance;
    public final int channels;
    public final int sampleRate;
    public final int maxFrameSize;
    public final int outputLength;
    private AtomicBoolean valid = new AtomicBoolean(true);

    public VorbisDecoder(byte[] idPacket, int idPacketOffset, int idPacketLength, byte[] setupPacket, int setupPacketOffset, int setupPacketLength) {
        if (idPacketOffset < 0 || idPacketOffset > idPacket.length || idPacketLength - idPacketOffset > idPacket.length || idPacketLength < 0) {
            throw new IndexOutOfBoundsException("idPacket out of bounds");
        }
        if (setupPacketOffset < 0 || setupPacketOffset > setupPacket.length || setupPacketLength - setupPacketOffset > setupPacket.length || setupPacketLength < 0) {
            throw new IndexOutOfBoundsException("setupPacket out of bounds");
        }
        this.instance = VorbisUnsafe.open(idPacket, idPacketOffset, idPacketLength, setupPacket, setupPacketOffset, setupPacketLength, DecoderErrorException.class);
        if (this.instance == 0L) {
            throw new DecoderErrorException("Unknown error");
        }
        this.channels = VorbisUnsafe.getChannels(this.instance);
        this.sampleRate = VorbisUnsafe.getSampleRate(this.instance);
        this.maxFrameSize = VorbisUnsafe.getMaxFrameSize(this.instance);
        this.outputLength = this.channels * this.maxFrameSize;
    }

    public final synchronized int getPacketSampleCount(byte[] packet, int packetOffset, int packetLength) {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        if (packetOffset < 0 || packetOffset > packet.length || packetLength - packetOffset > packet.length || packetLength < 0) {
            throw new IndexOutOfBoundsException("packet out of bounds");
        }
        return VorbisUnsafe.getPacketSampleCount(this.instance, packet, packetOffset, packetLength);
    }

    public final synchronized int decodeFrame(byte[] packet, int packetOffset, int packetLength, float[] output, int outputOffset) {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        if (packetOffset < 0 || packetOffset > packet.length || packetLength - packetOffset > packet.length || packetLength < 0) {
            throw new IndexOutOfBoundsException("packet out of bounds");
        }
        if (outputOffset < 0 || outputOffset > output.length || this.outputLength - outputOffset > output.length) {
            throw new IndexOutOfBoundsException("output out of bounds");
        }
        return VorbisUnsafe.decodeFrame(this.instance, packet, packetOffset, packetLength, output, outputOffset);
    }

    public final synchronized int getError() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        return VorbisUnsafe.getError(this.instance);
    }

    public final synchronized void flush() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        VorbisUnsafe.flush(this.instance);
    }

    @Override
    public synchronized void close() {
        if (this.valid.getAndSet(false)) {
            VorbisUnsafe.close(this.instance);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static class DecoderErrorException
    extends RuntimeException {
        public DecoderErrorException(String text) {
            super(text);
        }
    }
}

