/*
 * Decompiled with CFR 0.152.
 */
package gabien.natives;

import gabien.natives.InvalidatedPointerException;
import gabien.natives.MP3Enum;
import gabien.natives.MP3Unsafe;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MP3Decoder
extends MP3Enum
implements AutoCloseable {
    private final long instance;
    private AtomicBoolean valid = new AtomicBoolean(true);

    public MP3Decoder() {
        this.instance = MP3Unsafe.alloc(DecoderErrorException.class);
        if (this.instance == 0L) {
            throw new DecoderErrorException("Unknown error");
        }
    }

    public final synchronized void reset() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        MP3Unsafe.reset(this.instance);
    }

    public final synchronized int getLastFrameBytes() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        return MP3Unsafe.getLastFrameBytes(this.instance);
    }

    public final synchronized int getLastFrameSampleRate() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        return MP3Unsafe.getLastFrameSampleRate(this.instance);
    }

    public final synchronized int getLastFrameChannels() {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        return MP3Unsafe.getLastFrameChannels(this.instance);
    }

    public final synchronized int decodeFrame(byte[] packet, int packetOffset, int packetLength, float[] output, int outputOffset) {
        if (!this.valid.get()) {
            throw new InvalidatedPointerException(this);
        }
        if (packetOffset < 0 || packetOffset > packet.length || packetLength - packetOffset > packet.length || packetLength < 0) {
            throw new IndexOutOfBoundsException("packet out of bounds");
        }
        if (output != null && (outputOffset < 0 || outputOffset > output.length || 2304 - outputOffset > output.length)) {
            throw new IndexOutOfBoundsException("output out of bounds");
        }
        return MP3Unsafe.decodeFrame(this.instance, packet, packetOffset, packetLength, output, outputOffset);
    }

    @Override
    public synchronized void close() {
        if (this.valid.getAndSet(false)) {
            MP3Unsafe.free(this.instance);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public static class DecoderErrorException
    extends RuntimeException {
        public DecoderErrorException(String text) {
            super(text);
        }
    }
}

