/*
 * Decompiled with CFR 0.152.
 */
package gabien.natives;

import gabien.uslx.licensing.LicenseComponent;
import gabien.uslx.licensing.LicenseManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Function;

public abstract class Loader {
    public static final LicenseComponent LC_STB_VORBIS = new LicenseComponent("stb_vorbis", "https://github.com/nothings/stb/", "gabien/licensing/stb_vorbis/COPYING.txt", "gabien/licensing/stb_vorbis/CREDITS.txt");
    public static final LicenseComponent LC_MINIMP3 = new LicenseComponent("minimp3", "https://github.com/lieff/minimp3", "gabien/licensing/minimp3/LICENSE", null);

    private Loader() {
    }

    public static InputStream assetLookupJavaSE(String str) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream("assets/" + str);
    }

    public static File destinationSetupJavaSE(String fnf) {
        File tmp;
        try {
            tmp = File.createTempFile(fnf, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        tmp.deleteOnExit();
        return tmp;
    }

    public static boolean defaultLoaderJavaSE() {
        return Loader.defaultLoader(Loader::assetLookupJavaSE, Loader::destinationSetupJavaSE);
    }

    public static boolean defaultLoader(Function<String, InputStream> assetLookup, Function<String, File> destinationSetup) {
        StringWriter errors = new StringWriter();
        PrintWriter errorsP = new PrintWriter(errors);
        String[] cpu = new String[]{"x86_64", "aarch64", "riscv64", "x86", "arm", "mipsel"};
        String[] os = new String[]{"linux-gnu", "windows-gnu", "macos", "linux-android"};
        try {
            System.loadLibrary("gabien-natives");
            return true;
        }
        catch (Throwable ex) {
            errorsP.append("gabien.natives.Loader: loadLibrary(gabien-natives): " + ex + "\n");
            for (String o : os) {
                for (String c : cpu) {
                    if (!Loader.defaultLoaderConfig(c + "-" + o, errorsP)) continue;
                    return true;
                }
            }
            String detectedCPU = Loader.detectCPU();
            for (String o : os) {
                if (!Loader.loadWithTmpfile(detectedCPU + "-" + o, assetLookup, destinationSetup, errorsP)) continue;
                return true;
            }
            for (String o : os) {
                for (String c : cpu) {
                    if (!Loader.loadWithTmpfile(c + "-" + o, assetLookup, destinationSetup, errorsP)) continue;
                    return true;
                }
            }
            System.err.println("gabien.natives.Loader: Failed, information:");
            System.err.print(errors.toString());
            return false;
        }
    }

    private static String detectCPU() {
        String detectedCPU = System.getProperty("os.arch");
        if (detectedCPU.equalsIgnoreCase("amd64")) {
            detectedCPU = "x86_64";
        } else if (detectedCPU.equalsIgnoreCase("i686")) {
            detectedCPU = "x86";
        } else if (detectedCPU.contains("arm64")) {
            detectedCPU = "aarch64";
        } else if (detectedCPU.contains("arm")) {
            detectedCPU = "arm";
        } else if (detectedCPU.contains("mips")) {
            detectedCPU = "mipsel";
        }
        return detectedCPU;
    }

    private static boolean loadLibrary(String name, PrintWriter errorsP) {
        try {
            System.loadLibrary(name);
            return true;
        }
        catch (Throwable ex) {
            errorsP.append("gabien.natives.Loader: loadLibrary(" + name + "): " + ex + "\n");
            return false;
        }
    }

    private static boolean defaultLoaderConfig(String config, PrintWriter errorsP) {
        if (Loader.loadLibrary("gabien-natives-" + config, errorsP)) {
            return true;
        }
        String fn = "natives." + config;
        try {
            System.load(new File(fn).getAbsolutePath());
            return true;
        }
        catch (Throwable ex) {
            errorsP.append("gabien.natives.Loader: load(" + fn + "): " + ex + "\n");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadWithTmpfile(String config, Function<String, InputStream> assetLookup, Function<String, File> destinationSetup, PrintWriter errorsP) {
        String fn = "natives." + config;
        String fnf = "gabien-natives/" + fn;
        try {
            File tmp;
            try (InputStream inp = assetLookup.apply(fnf);){
                Throwable throwable;
                boolean rewriteNecessary;
                byte[] buf;
                block55: {
                    boolean bl;
                    block52: {
                        if (inp == null) {
                            errorsP.append("gabien.natives.Loader: loadViaTmpfile(" + fnf + "): doesn't exist!\n");
                            boolean bl2 = false;
                            return bl2;
                        }
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        buf = new byte[65536];
                        while (true) {
                            int rd;
                            if ((rd = inp.read(buf)) <= 0) {
                                buf = bos.toByteArray();
                                bos = null;
                                tmp = destinationSetup.apply(fn);
                                System.err.println("gabien.natives.Loader: " + fnf + " -> " + tmp);
                                if (tmp.length() != (long)buf.length) {
                                    break;
                                }
                                break block52;
                            }
                            bos.write(buf, 0, rd);
                        }
                        bl = true;
                        break block55;
                    }
                    bl = rewriteNecessary = false;
                }
                if (!rewriteNecessary) {
                    try {
                        throwable = null;
                        try (FileInputStream fis = new FileInputStream(tmp);){
                            for (byte b : buf) {
                                int b1 = b & 0xFF;
                                int b2 = fis.read();
                                if (b1 == b2) continue;
                                rewriteNecessary = true;
                                break;
                            }
                            if (!rewriteNecessary && fis.read() != -1) {
                                rewriteNecessary = true;
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable ex2) {
                        rewriteNecessary = true;
                    }
                }
                try {
                    throwable = null;
                    try (FileOutputStream fos = new FileOutputStream(tmp);){
                        fos.write(buf);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (Throwable ex2) {
                    ex2.printStackTrace();
                }
            }
            System.load(tmp.getAbsolutePath());
            return true;
        }
        catch (Throwable ex) {
            errorsP.append("gabien.natives.Loader: loadViaTmpfile(" + fnf + "): " + ex + "\n");
            return false;
        }
    }

    public static native String getNativesVersion();

    static {
        LicenseManager.I.register(LC_STB_VORBIS);
        LicenseManager.I.register(LC_MINIMP3);
        LicenseManager.I.dependency(LicenseComponent.LC_GABIEN, LC_STB_VORBIS);
        LicenseManager.I.dependency(LicenseComponent.LC_GABIEN, LC_MINIMP3);
    }
}

