/*
 * Decompiled with CFR 0.152.
 */
package gabien.natives;

import gabien.natives.BadGPUEnum;
import gabien.natives.BadGPUUnsafe;
import gabien.natives.InvalidatedPointerException;
import gabien.uslx.append.ThreadOwned;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class BadGPU
extends BadGPUEnum {
    private BadGPU() {
    }

    @NonNull
    public static Instance newInstance(int newInstanceFlags) {
        long instance = BadGPUUnsafe.newInstance(newInstanceFlags, InstanceCreationException.class);
        if (instance == 0L) {
            throw new InstanceCreationException("Unknown error");
        }
        return new Instance(instance);
    }

    public static boolean drawClear(@Nullable Texture sTexture, @Nullable DSBuffer sDSBuffer, int sFlags, int sScX, int sScY, int sScWidth, int sScHeight, float cR, float cG, float cB, float cA, float depth, int stencil) {
        if (sTexture == null && sDSBuffer == null) {
            return false;
        }
        if (sTexture != null && sDSBuffer != null) assert (sTexture.syncObject == sDSBuffer.syncObject);
        ThreadOwned syncObj = sTexture != null ? sTexture.syncObject : sDSBuffer.syncObject;
        syncObj.assertBound();
        if (sTexture != null && !sTexture.valid) {
            throw new InvalidatedPointerException(sTexture);
        }
        if (sDSBuffer != null && !sDSBuffer.valid) {
            throw new InvalidatedPointerException(sDSBuffer);
        }
        return BadGPUUnsafe.drawClear(sTexture != null ? sTexture.pointer : 0L, sDSBuffer != null ? sDSBuffer.pointer : 0L, sFlags, sScX, sScY, sScWidth, sScHeight, cR, cG, cB, cA, depth, stencil);
    }

    private static int getVertexCount(int iStart, int iCount, short[] indices, int indicesOfs) {
        if (iStart < 0) {
            throw new IllegalArgumentException("Not supposed to have iStart be < 0");
        }
        if (iCount < 0 || iCount > 65536) {
            throw new IllegalArgumentException("Not supposed to have iCount be < 0 or > 65536");
        }
        if (indicesOfs < 0) {
            throw new IllegalArgumentException("Not supposed to have indicesOfs be < 0");
        }
        if (indices == null) {
            return iStart + iCount;
        }
        iStart += indicesOfs;
        int vCount = 0;
        for (int i = 0; i < iCount; ++i) {
            int efCount = (indices[iStart] & 0xFFFF) + 1;
            if (efCount > vCount) {
                vCount = efCount;
            }
            ++iStart;
        }
        return vCount;
    }

    private static void checkVL(int flags, int vPosD, float[] vPos, int vPosOfs, float[] vCol, int vColOfs, int vTCD, float[] vTC, int vTCOfs, int iStart, int iCount, short[] indices, int indicesOfs, float[] matrixA, int matrixAOfs, float[] clipPlane, int clipPlaneOfs, float[] matrixT, int matrixTOfs) {
        if (vPosD < 2 || vPosD > 4) {
            throw new IllegalArgumentException("vPosD out of range");
        }
        if (vTCD < 2 || vTCD > 4) {
            throw new IllegalArgumentException("vTCD out of range");
        }
        int vCount = BadGPU.getVertexCount(iStart, iCount, indices, indicesOfs);
        int cCount = (flags & 0x80) != 0 ? 1 : vCount;
        int tCount = (flags & 0x100) != 0 ? 1 : vCount;
        cCount *= 4;
        tCount *= vTCD;
        if (vPosOfs < 0 || vPosOfs + (vCount *= vPosD) > vPos.length) {
            throw new IllegalArgumentException("vPos out of bounds");
        }
        if (vCol != null && (vColOfs < 0 || vColOfs + cCount > vCol.length)) {
            throw new IllegalArgumentException("vCol out of bounds");
        }
        if (vTC != null && (vTCOfs < 0 || vTCOfs + tCount > vTC.length)) {
            throw new IllegalArgumentException("vTC out of bounds");
        }
        if (matrixA != null && (matrixAOfs < 0 || matrixAOfs + 16 > matrixA.length)) {
            throw new IllegalArgumentException("matrixA out of bounds");
        }
        if (clipPlane != null && (clipPlaneOfs < 0 || clipPlaneOfs + 4 > clipPlane.length)) {
            throw new IllegalArgumentException("clipPlane out of bounds");
        }
        if (matrixT != null && (matrixTOfs < 0 || matrixTOfs + 16 > matrixT.length)) {
            throw new IllegalArgumentException("matrixT out of bounds");
        }
    }

    public static boolean drawGeom(@Nullable Texture sTexture, @Nullable DSBuffer sDSBuffer, int sFlags, int sScX, int sScY, int sScWidth, int sScHeight, int flags, int vPosD, float[] vPos, int vPosOfs, float[] vCol, int vColOfs, int vTCD, float[] vTC, int vTCOfs, BadGPUEnum.PrimitiveType pType, float plSize, int iStart, int iCount, short[] indices, int indicesOfs, float[] matrixA, int matrixAOfs, int vX, int vY, int vW, int vH, @Nullable Texture texture, float[] matrixT, int matrixTOfs, float[] clipPlane, int clipPlaneOfs, BadGPUEnum.Compare atFunc, float atRef, BadGPUEnum.Compare stFunc, int stRef, int stMask, BadGPUEnum.StencilOp stSF, BadGPUEnum.StencilOp stDF, BadGPUEnum.StencilOp stDP, BadGPUEnum.Compare dtFunc, float depthN, float depthF, float poFactor, float poUnits, int blendProgram) {
        ThreadOwned syncObj;
        if (sTexture == null && sDSBuffer == null) {
            return false;
        }
        if (sTexture != null && sDSBuffer != null) assert (sTexture.syncObject == sDSBuffer.syncObject);
        ThreadOwned threadOwned = syncObj = sTexture != null ? sTexture.syncObject : sDSBuffer.syncObject;
        if (texture != null) assert (syncObj == texture.syncObject);
        BadGPU.checkVL(flags, vPosD, vPos, vPosOfs, vCol, vColOfs, vTCD, vTC, vTCOfs, iStart, iCount, indices, indicesOfs, matrixA, matrixAOfs, clipPlane, clipPlaneOfs, matrixT, matrixTOfs);
        syncObj.assertBound();
        if (sTexture != null && !sTexture.valid) {
            throw new InvalidatedPointerException(sTexture);
        }
        if (sDSBuffer != null && !sDSBuffer.valid) {
            throw new InvalidatedPointerException(sDSBuffer);
        }
        if (texture != null && !texture.valid) {
            throw new InvalidatedPointerException(texture);
        }
        return BadGPUUnsafe.drawGeom(sTexture != null ? sTexture.pointer : 0L, sDSBuffer != null ? sDSBuffer.pointer : 0L, sFlags, sScX, sScY, sScWidth, sScHeight, flags, vPosD, vPos, vPosOfs, vCol, vColOfs, vTCD, vTC, vTCOfs, pType.value, plSize, iStart, iCount, indices, indicesOfs, matrixA, matrixAOfs, vX, vY, vW, vH, texture != null ? texture.pointer : 0L, matrixT, matrixTOfs, clipPlane, clipPlaneOfs, atFunc.value, atRef, stFunc.value, stRef, stMask, stSF.value, stDF.value, stDP.value, dtFunc.value, depthN, depthF, poFactor, poUnits, blendProgram);
    }

    public static boolean drawGeomNoDS(@Nullable Texture sTexture, int sFlags, int sScX, int sScY, int sScWidth, int sScHeight, int flags, int vPosD, float[] vPos, int vPosOfs, float[] vCol, int vColOfs, int vTCD, float[] vTC, int vTCOfs, BadGPUEnum.PrimitiveType pType, float plSize, int iStart, int iCount, short[] indices, int indicesOfs, float[] matrixA, int matrixAOfs, int vX, int vY, int vW, int vH, @Nullable Texture texture, float[] matrixT, int matrixTOfs, float[] clipPlane, int clipPlaneOfs, BadGPUEnum.Compare atFunc, float atRef, int blendProgram) {
        if (sTexture == null) {
            return false;
        }
        if (texture != null) assert (sTexture.syncObject == texture.syncObject);
        BadGPU.checkVL(flags, vPosD, vPos, vPosOfs, vCol, vColOfs, vTCD, vTC, vTCOfs, iStart, iCount, indices, indicesOfs, matrixA, matrixAOfs, clipPlane, clipPlaneOfs, matrixT, matrixTOfs);
        sTexture.syncObject.assertBound();
        if (!sTexture.valid) {
            throw new InvalidatedPointerException(sTexture);
        }
        if (texture != null && !texture.valid) {
            throw new InvalidatedPointerException(texture);
        }
        return BadGPUUnsafe.drawGeomNoDS(sTexture != null ? sTexture.pointer : 0L, sFlags, sScX, sScY, sScWidth, sScHeight, flags, vPosD, vPos, vPosOfs, vCol, vColOfs, vTCD, vTC, vTCOfs, pType.value, plSize, iStart, iCount, indices, indicesOfs, matrixA, matrixAOfs, vX, vY, vW, vH, texture != null ? texture.pointer : 0L, matrixT, matrixTOfs, clipPlane, clipPlaneOfs, atFunc.value, atRef, blendProgram);
    }

    public static final class DSBuffer
    extends Ref {
        private DSBuffer(Ref i, long l) {
            super(i, l);
        }
    }

    public static final class Texture
    extends Ref {
        private Texture(Ref i, long l) {
            super(i, l);
        }

        public boolean generateMipmap() {
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            return BadGPUUnsafe.generateMipmap(this.pointer);
        }

        private void readPixelsChecks(int x, int y, int width, int height, BadGPUEnum.TextureLoadFormat fmt, int dataOfs, int dataLen) {
            Texture.readPixelsBoundsChecks(x, y, width, height, fmt, dataOfs, dataLen);
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
        }

        public boolean readPixels(int x, int y, int width, int height, BadGPUEnum.TextureLoadFormat fmt, byte[] data, int dataOfs) {
            if (width == 0 || height == 0) {
                return true;
            }
            if (data == null) {
                throw new IllegalArgumentException("data must not be null.");
            }
            this.readPixelsChecks(x, y, width, height, fmt, dataOfs, data.length);
            return BadGPUUnsafe.readPixelsB(this.pointer, x, y, width, height, fmt.value, data, dataOfs);
        }

        public boolean readPixels(int x, int y, int width, int height, BadGPUEnum.TextureLoadFormat fmt, int[] data, int dataOfs) {
            if (width == 0 || height == 0) {
                return true;
            }
            if (data == null) {
                throw new IllegalArgumentException("data must not be null.");
            }
            this.readPixelsChecks(x, y, width, height, fmt, dataOfs * 4, data.length * 4);
            return BadGPUUnsafe.readPixelsI(this.pointer, x, y, width, height, fmt.value, data, dataOfs);
        }

        private static void readPixelsBoundsChecks(int x, int y, int width, int height, BadGPUEnum.TextureLoadFormat fmt, int dataOfs, int dataLen) {
            if (width >= 32768 || height >= 32768 || width < 1 || height < 1) {
                throw new IllegalArgumentException("Width/height not 0-32767.");
            }
            int size = (int)BadGPUUnsafe.pixelsSize(fmt.value, width, height);
            if (size < 0) {
                throw new IllegalArgumentException("Size overflow.");
            }
            if (dataOfs < 0 || dataOfs > dataLen) {
                throw new IllegalArgumentException("Offset not within buffer.");
            }
            if (dataLen - dataOfs < size) {
                throw new IllegalArgumentException("Region not within buffer.");
            }
        }
    }

    public static final class Instance
    extends Ref {
        private Instance(long l) {
            super(new TransferImpl(l), l);
        }

        @Nullable
        public String getMetaInfo(BadGPUEnum.MetaInfoType type) {
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            return BadGPUUnsafe.getMetaInfo(this.pointer, type.value);
        }

        public void flush() {
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            BadGPUUnsafe.flushInstance(this.pointer);
        }

        public void finish() {
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            BadGPUUnsafe.finishInstance(this.pointer);
        }

        @Nullable
        public Texture newTexture(int width, int height) {
            if (width >= 32768 || height >= 32768 || width < 1 || height < 1) {
                throw new IllegalArgumentException("Width/height not 0-32767.");
            }
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            long res = BadGPUUnsafe.newTextureI(this.pointer, width, height, 0, null, 0);
            return res == 0L ? null : new Texture(this, res);
        }

        @Nullable
        public Texture newTexture(int width, int height, BadGPUEnum.TextureLoadFormat fmt, byte[] data, int dataOfs) {
            this.newTextureChecks(width, height, fmt, dataOfs, data != null ? data.length : -1);
            long res = BadGPUUnsafe.newTextureB(this.pointer, width, height, fmt.value, data, dataOfs);
            return res == 0L ? null : new Texture(this, res);
        }

        @Nullable
        public Texture newTexture(int width, int height, BadGPUEnum.TextureLoadFormat fmt, int[] data, int dataOfs) {
            this.newTextureChecks(width, height, fmt, dataOfs, data != null ? data.length * 4 : -1);
            long res = BadGPUUnsafe.newTextureI(this.pointer, width, height, fmt.value, data, dataOfs);
            return res == 0L ? null : new Texture(this, res);
        }

        private void newTextureChecks(int width, int height, BadGPUEnum.TextureLoadFormat fmt, int dataOfs, int dataLen) {
            if (width >= 32768 || height >= 32768 || width < 1 || height < 1) {
                throw new IllegalArgumentException("Width/height not 0-32767.");
            }
            if (dataLen != -1) {
                int size = (int)BadGPUUnsafe.pixelsSize(fmt.value, width, height);
                if (size <= 0) {
                    throw new IllegalArgumentException("Size overflow.");
                }
                if (dataOfs < 0) {
                    throw new IllegalArgumentException("Data offset before start.");
                }
                if (dataOfs > dataLen) {
                    throw new IllegalArgumentException("Data offset after end.");
                }
                if (dataOfs + size > dataLen) {
                    throw new IllegalArgumentException("Data region after end.");
                }
            }
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
        }

        @Nullable
        public DSBuffer newDSBuffer(int width, int height) {
            this.syncObject.assertBound();
            if (!this.valid) {
                throw new InvalidatedPointerException(this);
            }
            long res = BadGPUUnsafe.newDSBuffer(this.pointer, width, height);
            return res == 0L ? null : new DSBuffer(this, res);
        }
    }

    public static class Ref {
        public final ThreadOwned syncObject;
        final TransferImpl syncObjectInternal;
        public final long pointer;
        protected volatile boolean valid = true;

        private Ref(TransferImpl ib, long l) {
            this.syncObject = ib;
            this.syncObjectInternal = ib;
            this.pointer = l;
        }

        private Ref(Ref i, long l) {
            this.syncObject = i.syncObject;
            this.syncObjectInternal = i.syncObjectInternal;
            this.pointer = l;
        }

        public final boolean isValid() {
            return this.valid;
        }

        public void dispose() {
            this.syncObject.assertBound();
            if (this.valid) {
                this.valid = false;
                BadGPUUnsafe.unref(this.pointer);
                if (this.pointer == this.syncObjectInternal.instance) {
                    this.syncObjectInternal.shutdown = true;
                }
            }
        }
    }

    private static final class TransferImpl
    extends ThreadOwned {
        private final long instance;
        private volatile boolean shutdown;

        private TransferImpl(long l) {
            this.instance = l;
        }

        @Override
        protected void bindImpl() {
            if (this.shutdown) {
                return;
            }
            if (!BadGPUUnsafe.bindInstance(this.instance)) {
                throw new InstanceBindException();
            }
        }

        @Override
        protected void unbindImpl() {
            if (this.shutdown) {
                return;
            }
            BadGPUUnsafe.unbindInstance(this.instance);
        }
    }

    public static class InstanceBindException
    extends RuntimeException {
        public InstanceBindException() {
            super("Instance bind failed.");
        }
    }

    public static class InstanceCreationException
    extends RuntimeException {
        public InstanceCreationException(String text) {
            super(text);
        }
    }
}

