/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.riff;

import gabien.uslx.io.LEDataOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class RIFFOutputStream
extends LEDataOutputStream {
    @NonNull
    private final LEDataOutputStream targetDos;
    @Nullable
    private final ByteArrayOutputStream buffer;
    private final int plannedLength;

    public RIFFOutputStream(@NonNull OutputStream base, @NonNull String id) throws IOException {
        this(new LEDataOutputStream(base), id);
    }

    public RIFFOutputStream(@NonNull LEDataOutputStream base, @NonNull String id) throws IOException {
        super(new ByteArrayOutputStream());
        this.targetDos = base;
        this.buffer = (ByteArrayOutputStream)this.out;
        if (id.length() != 4) {
            throw new IOException("RIFF chunk ID must be 4 characters.");
        }
        this.targetDos.writeBytes(id);
        this.plannedLength = -1;
    }

    public static int getInteriorChunkSize(int len) {
        return 8 + len + (RIFFOutputStream.shouldPad(len) ? 1 : 0);
    }

    public RIFFOutputStream(@NonNull OutputStream base, @NonNull String id, int length) throws IOException {
        super(base);
        this.targetDos = this;
        this.buffer = null;
        if (id.length() != 4) {
            throw new IOException("RIFF chunk ID must be 4 characters.");
        }
        this.writeBytes(id);
        this.writeInt(length);
        this.written = 0;
        this.plannedLength = length;
    }

    public static void putChunk(OutputStream os, String id, byte[] content) throws IOException {
        RIFFOutputStream.putChunk(new LEDataOutputStream(os), id, content);
    }

    public static void putChunk(LEDataOutputStream os, String id, byte[] content) throws IOException {
        if (id.length() != 4) {
            throw new IOException("RIFF chunk ID must be 4 characters.");
        }
        os.writeBytes(id);
        int len = content.length;
        os.writeInt(len);
        os.write(content);
        if (RIFFOutputStream.shouldPad(len)) {
            os.write(0);
        }
    }

    public static boolean shouldPad(int len) {
        int pad = len & 1;
        return pad != 0;
    }

    @Override
    public void close() throws IOException {
        if (this.buffer != null) {
            int sz = this.buffer.size();
            this.targetDos.writeInt(sz);
            this.buffer.writeTo(this.targetDos);
            if (RIFFOutputStream.shouldPad(sz)) {
                this.targetDos.write(0);
            }
        } else {
            if (this.written != this.plannedLength) {
                throw new IOException("Fixed-size RIFFOutputStream was told to write " + this.plannedLength + " but got " + this.written + ".");
            }
            if (RIFFOutputStream.shouldPad(this.plannedLength)) {
                this.out.write(0);
            }
        }
        this.out = null;
    }
}

