/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.riff;

import gabien.media.riff.RIFFInputStream;
import gabien.media.riff.RIFFOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;

public abstract class RIFFNode {
    public String chunkId = "test";

    public abstract RIFFNode copy();

    public static RIFFNode read(InputStream xe) throws IOException {
        try (RIFFInputStream ris = new RIFFInputStream(xe);){
            if (ris.chunkId.equals("RIFF") || ris.chunkId.equals("LIST")) {
                CList cList = new CList(ris);
                return cList;
            }
            CData cData = new CData(ris);
            return cData;
        }
    }

    public abstract void write(OutputStream var1) throws IOException;

    public static final class CList
    extends RIFFNode {
        public String subChunkId = "test";
        public final LinkedList<RIFFNode> contents = new LinkedList();

        public CList(String cid, String scid) {
            this.chunkId = cid;
            this.subChunkId = scid;
        }

        public CList(RIFFInputStream ris) throws IOException {
            this.chunkId = ris.chunkId;
            this.subChunkId = ris.readFourCC();
            while (ris.available() > 0) {
                this.contents.add(CList.read(ris));
            }
        }

        @Override
        public RIFFNode copy() {
            CList n = new CList(this.chunkId, this.subChunkId);
            for (RIFFNode rn : this.contents) {
                n.contents.add(rn.copy());
            }
            return n;
        }

        @Override
        public void write(OutputStream xe) throws IOException {
            try (RIFFOutputStream ros = new RIFFOutputStream(xe, this.chunkId);){
                if (this.subChunkId.length() != 4) {
                    throw new IOException("RIFF subchunk ID must be 4 characters.");
                }
                ros.writeBytes(this.subChunkId);
                for (RIFFNode rn : this.contents) {
                    rn.write(ros);
                }
            }
        }
    }

    public static final class CData
    extends RIFFNode {
        public byte[] contents;

        public CData() {
            this.contents = new byte[0];
        }

        public CData(RIFFInputStream ris) throws IOException {
            this.chunkId = ris.chunkId;
            this.contents = new byte[ris.chunkLen];
            ris.readFully(this.contents);
        }

        @Override
        public RIFFNode copy() {
            CData n = new CData();
            n.chunkId = this.chunkId;
            n.contents = (byte[])this.contents.clone();
            return n;
        }

        @Override
        public void write(OutputStream xe) throws IOException {
            RIFFOutputStream.putChunk(xe, this.chunkId, this.contents);
        }
    }
}

