/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.riff;

import gabien.media.ChunkedInputStream;
import gabien.media.riff.RIFFOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public class RIFFInputStream
extends ChunkedInputStream {
    @NonNull
    public final String chunkId;
    private String chunkIdTmp;
    private int chunkPaddedLen;

    public RIFFInputStream(@NonNull InputStream in) throws IOException {
        super(in, null);
        this.chunkId = this.chunkIdTmp;
    }

    @Override
    protected int readChunkHeader(Object indicator) throws IOException {
        int len;
        this.chunkIdTmp = this.readFourCC();
        this.chunkPaddedLen = len = super.readInt();
        if (RIFFOutputStream.shouldPad(len)) {
            ++this.chunkPaddedLen;
        }
        return len;
    }

    public void readListOrRiffTypeAndVerify(String expectedRIFFHead, String expectedLISTHead) throws IOException {
        boolean isLISTwave;
        String rc = this.readFourCC();
        boolean isRIFFWAVE = this.chunkId.equals("RIFF") && rc.equals(expectedRIFFHead);
        boolean bl = isLISTwave = this.chunkId.equals("LIST") && rc.equals(expectedLISTHead);
        if (!isRIFFWAVE && !isLISTwave) {
            throw new IOException("File expected to be RIFF;" + expectedRIFFHead + " or LIST;" + expectedLISTHead + " but was actually " + this.chunkId + ";" + rc);
        }
    }

    @Override
    public void close() throws IOException {
        this.holdoffLimiters = true;
        this.skipBytes(this.chunkPaddedLen - this.chunkPos);
        this.holdoffLimiters = false;
    }
}

