/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.riff;

import gabien.media.riff.RIFFInputStream;
import gabien.media.riff.RIFFOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class RIFFInfoChunk {
    public HashMap<String, byte[]> keys = new HashMap();

    public String getAsString(String id, String def) {
        byte[] res = this.keys.get(id);
        if (res != null) {
            return new String(res, StandardCharsets.UTF_8);
        }
        return def;
    }

    public void putAsString(String id, String value) {
        this.keys.put(id, value.getBytes(StandardCharsets.UTF_8));
    }

    public void readInterior(@NonNull InputStream is) throws IOException {
        while (is.available() > 0) {
            RIFFInputStream ris = new RIFFInputStream(is);
            this.keys.put(ris.chunkId, ris.readToEnd());
            ris.close();
        }
    }

    public void write(@NonNull OutputStream os) throws IOException {
        RIFFOutputStream ros = new RIFFOutputStream(os, "LIST");
        ros.writeBytes("INFO");
        for (Map.Entry<String, byte[]> entry : this.keys.entrySet()) {
            RIFFOutputStream.putChunk(ros, entry.getKey(), entry.getValue());
        }
        ros.close();
    }
}

