/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.ogg;

public final class OggReader {
    public final byte[] syncWindow = new byte[65307];
    public int amountOfDataInSyncWindow = 0;

    public void reset() {
        this.amountOfDataInSyncWindow = 0;
    }

    public void addByteToSyncWindow(byte b) {
        if (this.amountOfDataInSyncWindow < this.syncWindow.length) {
            this.syncWindow[this.amountOfDataInSyncWindow++] = b;
        } else {
            System.arraycopy(this.syncWindow, 1, this.syncWindow, 0, this.syncWindow.length - 1);
            this.syncWindow[this.syncWindow.length - 1] = b;
        }
    }

    public void skipSyncWindow(int len) {
        if (this.amountOfDataInSyncWindow < len) {
            throw new RuntimeException("Can't skip more bytes than are in the sync window!");
        }
        System.arraycopy(this.syncWindow, len, this.syncWindow, 0, this.amountOfDataInSyncWindow - len);
        this.amountOfDataInSyncWindow -= len;
    }
}

