/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.ogg;

import gabien.media.ogg.OggSegmentReceiver;
import gabien.uslx.io.CRC32Forward;

public abstract class OggPage {
    public static final int MAX_PAGE_LENGTH = 65307;
    public static final int FIELD_FLAGS = 5;
    public static final int FIELD_GRANULEPOS = 6;
    public static final int FIELD_STREAMID = 14;
    public static final int FIELD_SEQNUM = 18;
    public static final int FIELD_CRC32 = 22;
    public static final int FLAG_CONTINUED = 1;
    public static final int FLAG_BOS = 2;
    public static final int FLAG_EOS = 4;

    private OggPage() {
    }

    public static long getGranulePos(byte[] syncWindow, int at) {
        at += 6;
        long a = (long)syncWindow[at++] & 0xFFL;
        long b = (long)syncWindow[at++] & 0xFFL;
        long c = (long)syncWindow[at++] & 0xFFL;
        long d = (long)syncWindow[at++] & 0xFFL;
        long e = (long)syncWindow[at++] & 0xFFL;
        long f = (long)syncWindow[at++] & 0xFFL;
        long g = (long)syncWindow[at++] & 0xFFL;
        long h = (long)syncWindow[at] & 0xFFL;
        a |= b << 8;
        a |= c << 16;
        a |= d << 24;
        a |= e << 32;
        a |= f << 40;
        a |= g << 48;
        return a |= h << 56;
    }

    public static int getStreamID(byte[] syncWindow, int at) {
        at += 14;
        int a = syncWindow[at++] & 0xFF;
        int b = syncWindow[at++] & 0xFF;
        int c = syncWindow[at++] & 0xFF;
        int d = syncWindow[at] & 0xFF;
        a |= b << 8;
        a |= c << 16;
        return a |= d << 24;
    }

    public static int getSeqNum(byte[] syncWindow, int at) {
        at += 18;
        int a = syncWindow[at++] & 0xFF;
        int b = syncWindow[at++] & 0xFF;
        int c = syncWindow[at++] & 0xFF;
        int d = syncWindow[at] & 0xFF;
        a |= b << 8;
        a |= c << 16;
        return a |= d << 24;
    }

    public static int getCRC32(byte[] syncWindow, int at) {
        at += 22;
        int a = syncWindow[at++] & 0xFF;
        int b = syncWindow[at++] & 0xFF;
        int c = syncWindow[at++] & 0xFF;
        int d = syncWindow[at] & 0xFF;
        a |= b << 8;
        a |= c << 16;
        return a |= d << 24;
    }

    public static int getLength(byte[] syncWindow, int at) {
        int segmentCount = syncWindow[at + 26] & 0xFF;
        int totalLength = 27 + segmentCount;
        for (int i = 0; i < segmentCount; ++i) {
            totalLength += syncWindow[at + 27 + i] & 0xFF;
        }
        return totalLength;
    }

    public static int verifyAndGetLength(byte[] syncWindow, int at, int amountOfDataInSyncWindow) {
        if (amountOfDataInSyncWindow < 27) {
            return 0;
        }
        if (syncWindow[at] != 79) {
            return 0;
        }
        if (syncWindow[at + 1] != 103) {
            return 0;
        }
        if (syncWindow[at + 2] != 103) {
            return 0;
        }
        if (syncWindow[at + 3] != 83) {
            return 0;
        }
        if (syncWindow[at + 4] != 0) {
            return 0;
        }
        int length = OggPage.getLength(syncWindow, at);
        if (amountOfDataInSyncWindow < length) {
            return 0;
        }
        int crc32 = 0;
        CRC32Forward checksum = CRC32Forward.CRC32_04C11DB7;
        crc32 = checksum.update(crc32, syncWindow, at, 22);
        crc32 = checksum.update(crc32, (byte)0);
        crc32 = checksum.update(crc32, (byte)0);
        crc32 = checksum.update(crc32, (byte)0);
        crc32 = checksum.update(crc32, (byte)0);
        if ((crc32 = checksum.update(crc32, syncWindow, at + 26, length - 26)) != OggPage.getCRC32(syncWindow, at)) {
            return 0;
        }
        return length;
    }

    public static int sendSegmentsTo(byte[] syncWindow, int at, OggSegmentReceiver.Discardable osr, boolean ignoreContinued) {
        boolean ignoreFirstPacket = false;
        if ((syncWindow[at + 5] & 1) == 0) {
            osr.discard();
        } else {
            ignoreFirstPacket = ignoreContinued;
        }
        int segmentCount = syncWindow[at + 26] & 0xFF;
        int ofs = at + 27 + segmentCount;
        int finishedPackets = 0;
        for (int i = 0; i < segmentCount; ++i) {
            int len = syncWindow[at + 27 + i] & 0xFF;
            if (!ignoreFirstPacket) {
                osr.segment(syncWindow, ofs, (byte)len);
            }
            if (len != 255) {
                ignoreFirstPacket = false;
                ++finishedPackets;
            }
            ofs += len;
        }
        osr.invalidateStorage();
        return finishedPackets;
    }
}

