/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.ogg;

import gabien.media.ogg.OggPacketReceiver;
import gabien.media.ogg.OggSegmentReceiver;
import java.io.ByteArrayOutputStream;
import org.eclipse.jdt.annotation.Nullable;

public final class OggPacketsFromSegments
implements OggSegmentReceiver.Discardable {
    @Nullable
    private byte[] zeroCopySrc;
    private int zeroCopyOfs;
    private int packetLen;
    private final ByteArrayOutputStream collation = new ByteArrayOutputStream();
    private final OggPacketReceiver output;

    public OggPacketsFromSegments(OggPacketReceiver o) {
        this.output = o;
    }

    @Override
    public final void segment(byte[] data, int ofs, byte len) {
        int leni = len & 0xFF;
        if (this.packetLen == 0) {
            this.zeroCopySrc = data;
            this.zeroCopyOfs = ofs;
        } else if (leni != 0) {
            if (this.zeroCopySrc != null) {
                if (data != this.zeroCopySrc || ofs != this.zeroCopyOfs + this.packetLen) {
                    this.transferFromZeroCopy();
                    this.collation.write(data, ofs, leni);
                }
            } else {
                this.collation.write(data, ofs, leni);
            }
        }
        this.packetLen += leni;
        if (leni != 255) {
            if (this.zeroCopySrc == null) {
                byte[] total = this.collation.toByteArray();
                this.output.packet(total, 0, this.packetLen);
                this.collation.reset();
            } else {
                this.output.packet(this.zeroCopySrc, this.zeroCopyOfs, this.packetLen);
                this.zeroCopySrc = null;
            }
            this.packetLen = 0;
        }
    }

    @Override
    public void invalidateStorage() {
        if (this.zeroCopySrc != null) {
            this.transferFromZeroCopy();
        }
    }

    private void transferFromZeroCopy() {
        this.collation.reset();
        this.collation.write(this.zeroCopySrc, this.zeroCopyOfs, this.packetLen);
        this.zeroCopySrc = null;
    }

    @Override
    public final void discard() {
        this.collation.reset();
        this.zeroCopySrc = null;
        this.packetLen = 0;
    }
}

