/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.ogg;

import gabien.media.ogg.OggPage;
import gabien.media.ogg.OggPageReceiver;
import gabien.media.ogg.OggReader;
import java.io.IOException;
import java.io.InputStream;

public class OggBufferingInputStreamReader {
    private final byte[] chunkBuffer = new byte[512];
    private int chunkBufferPosition;
    private int chunkBufferRemaining;
    private final OggReader or = new OggReader();
    private final InputStream inp;
    public OggPageReceiver out;

    public OggBufferingInputStreamReader(InputStream inp, OggPageReceiver opr) {
        this.inp = inp;
        this.out = opr;
    }

    public void readStartingBOSPages() throws IOException {
        while (true) {
            if (this.chunkBufferRemaining > 0) {
                boolean isBOS;
                this.or.addByteToSyncWindow(this.chunkBuffer[this.chunkBufferPosition++]);
                --this.chunkBufferRemaining;
                int len = OggPage.verifyAndGetLength(this.or.syncWindow, 0, this.or.amountOfDataInSyncWindow);
                if (len <= 0) continue;
                byte flags = this.or.syncWindow[5];
                boolean bl = isBOS = (flags & 2) != 0;
                if (!isBOS) {
                    return;
                }
                this.out.page(this.or.syncWindow, 0, len);
                this.or.skipSyncWindow(len);
                continue;
            }
            if (!this.refillChunkBuffer()) break;
        }
    }

    public boolean readNextPage() throws IOException {
        while (true) {
            if (this.chunkBufferRemaining > 0) {
                this.or.addByteToSyncWindow(this.chunkBuffer[this.chunkBufferPosition++]);
                --this.chunkBufferRemaining;
                int len = OggPage.verifyAndGetLength(this.or.syncWindow, 0, this.or.amountOfDataInSyncWindow);
                if (len <= 0) continue;
                this.out.page(this.or.syncWindow, 0, len);
                this.or.skipSyncWindow(len);
                return true;
            }
            if (!this.refillChunkBuffer()) break;
        }
        return false;
    }

    private boolean refillChunkBuffer() throws IOException {
        int amount = this.inp.read(this.chunkBuffer);
        if (amount == -1) {
            return false;
        }
        this.chunkBufferPosition = 0;
        this.chunkBufferRemaining = amount;
        return true;
    }
}

