/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.ogg;

import gabien.media.ogg.OggPacketsFromSegments;
import gabien.media.ogg.OggPage;
import gabien.media.ogg.OggPageReceiver;
import java.util.HashMap;
import java.util.LinkedList;

public class OggBufferedDemux
implements OggPageReceiver {
    public final LinkedList<Stream> streams = new LinkedList();
    public final HashMap<Integer, Stream> activeStreams = new HashMap();

    @Override
    public void page(byte[] data, int ofs, int len) {
        boolean isEOS;
        Stream theStream = null;
        int streamID = OggPage.getStreamID(data, ofs);
        byte flags = data[ofs + 5];
        boolean isBOS = (flags & 2) != 0;
        boolean bl = isEOS = (flags & 4) != 0;
        if (isBOS) {
            theStream = new Stream(streamID);
            this.streams.add(theStream);
            this.activeStreams.put(streamID, theStream);
        }
        if (theStream != null) {
            theStream.pageStreamIDChecked(data, ofs);
            if (isEOS) {
                this.activeStreams.remove(streamID);
            }
        }
    }

    public static class Stream
    implements OggPageReceiver {
        public final LinkedList<byte[]> packets = new LinkedList();
        public final int streamID;
        public long lastGranulePos;
        public boolean hasBeenShutdown = false;
        private final OggPacketsFromSegments opfs = new OggPacketsFromSegments((data, ofs, len) -> {
            byte[] res = new byte[len];
            System.arraycopy(data, ofs, res, 0, len);
            this.packets.add(res);
        });

        public Stream(int id) {
            this.streamID = id;
        }

        @Override
        public void page(byte[] data, int ofs, int len) {
            if (OggPage.getStreamID(data, ofs) != this.streamID) {
                return;
            }
            this.pageStreamIDChecked(data, ofs);
        }

        private void pageStreamIDChecked(byte[] data, int ofs) {
            if (this.hasBeenShutdown) {
                return;
            }
            this.lastGranulePos = OggPage.getGranulePos(data, ofs);
            OggPage.sendSegmentsTo(data, ofs, this.opfs, false);
            if ((data[ofs + 5] & 4) != 0) {
                this.hasBeenShutdown = true;
            }
        }
    }
}

