/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import datum.DatumInvalidVisitor;
import datum.DatumSrcLoc;
import datum.DatumVisitor;
import datum.DatumWriter;
import gabien.datum.DatumExpectListVisitor;
import gabien.datum.DatumKVDVisitor;
import gabien.datum.DatumTreeCallbackVisitor;
import gabien.media.midi.newsynth.CurvePlotter;
import gabien.media.midi.newsynth.NSLoopedWaveform;
import gabien.media.midi.newsynth.NSUnloopedWaveform;
import java.util.Random;

public class NSPatch {
    private static int CACHED_WAVEFORM_LEN = 512;
    public String name = "new patch";
    public final NSUnloopedWaveform volumeWaveform = new NSUnloopedWaveform();
    public final NSLoopedWaveform mainWaveform = new NSLoopedWaveform();
    public final NSUnloopedWaveform pitchEnvWaveform = new NSUnloopedWaveform();
    public int strikeMs = 100;
    public int releaseMs = 500;
    public int fixedFrequency = 0;
    public int octaveShift = 0;
    public int mainWaveformSamples = 8192;
    public boolean sustainEnabled = true;
    public boolean noiseEnabled = false;
    private float[] mainWaveformCache = new float[1];
    private final float[] envWaveformCache = new float[CACHED_WAVEFORM_LEN];
    private final float[] pitchEnvWaveformCache = new float[CACHED_WAVEFORM_LEN];
    private volatile boolean cacheDirty = true;

    public NSPatch() {
        this.volumeWaveform.pointData = new float[]{0.0f, 0.0f, 0.125f, 0.0f, 0.25f, 0.0f, 0.26f, 0.5f, 0.27f, 0.5f, 0.28f, 0.5f, 0.4f, 0.125f, 0.5f, 0.125f, 0.75f, 0.0f, 1.0f, 0.0f};
    }

    public float[] getMainWaveform() {
        if (this.cacheDirty) {
            this.regenCaches();
        }
        return this.mainWaveformCache;
    }

    public float[] getEnvWaveform() {
        if (this.cacheDirty) {
            this.regenCaches();
        }
        return this.envWaveformCache;
    }

    public float[] getPitchEnvWaveform() {
        if (this.cacheDirty) {
            this.regenCaches();
        }
        return this.pitchEnvWaveformCache;
    }

    public synchronized void markCachesDirty() {
        this.cacheDirty = true;
    }

    public synchronized void regenCaches() {
        this.cacheDirty = false;
        if (this.mainWaveformCache.length != this.mainWaveformSamples) {
            this.mainWaveformCache = new float[this.mainWaveformSamples];
        }
        CurvePlotter.resolve(this.mainWaveform, this.mainWaveformCache, this.noiseEnabled ? CurvePlotter.NormalizationMode.None : CurvePlotter.NormalizationMode.RecentreDC);
        if (this.noiseEnabled) {
            Random r = new Random(this.name.hashCode());
            int i = 0;
            while (i < this.mainWaveformCache.length) {
                int n = i++;
                this.mainWaveformCache[n] = (float)((double)this.mainWaveformCache[n] * r.nextGaussian());
            }
        }
        CurvePlotter.resolve(this.volumeWaveform, this.envWaveformCache, CurvePlotter.NormalizationMode.None);
        CurvePlotter.resolve(this.pitchEnvWaveform, this.pitchEnvWaveformCache, CurvePlotter.NormalizationMode.None);
    }

    public void writeToDatum(DatumWriter writer) {
        DatumWriter lst = writer.visitList(DatumSrcLoc.NONE);
        lst.visitId("name", DatumSrcLoc.NONE);
        lst.visitString(this.name, DatumSrcLoc.NONE);
        ++lst.indent;
        lst.visitNewline();
        lst.visitId("sustainEnabled", DatumSrcLoc.NONE);
        lst.visitBoolean(this.sustainEnabled, DatumSrcLoc.NONE);
        lst.visitId("noiseEnabled", DatumSrcLoc.NONE);
        lst.visitBoolean(this.noiseEnabled, DatumSrcLoc.NONE);
        lst.visitId("strikeMs", DatumSrcLoc.NONE);
        lst.visitInt(this.strikeMs, DatumSrcLoc.NONE);
        lst.visitId("releaseMs", DatumSrcLoc.NONE);
        lst.visitInt(this.releaseMs, DatumSrcLoc.NONE);
        lst.visitId("fixedFrequency", DatumSrcLoc.NONE);
        lst.visitInt(this.fixedFrequency, DatumSrcLoc.NONE);
        lst.visitId("octaveShift", DatumSrcLoc.NONE);
        lst.visitInt(this.octaveShift, DatumSrcLoc.NONE);
        lst.visitId("mainWaveformSamples", DatumSrcLoc.NONE);
        lst.visitInt(this.mainWaveformSamples, DatumSrcLoc.NONE);
        lst.visitNewline();
        lst.visitId("env", DatumSrcLoc.NONE);
        this.volumeWaveform.writeToDatum(writer);
        lst.visitNewline();
        lst.visitId("wave", DatumSrcLoc.NONE);
        this.mainWaveform.writeToDatum(writer);
        lst.visitNewline();
        lst.visitId("pitchEnv", DatumSrcLoc.NONE);
        this.pitchEnvWaveform.writeToDatum(writer);
        --lst.indent;
        lst.visitNewline();
        lst.visitEnd(DatumSrcLoc.NONE);
    }

    public DatumVisitor createDatumReadVisitor() {
        return new DatumExpectListVisitor(() -> new DatumKVDVisitor(){

            @Override
            public DatumVisitor handle(String key, DatumSrcLoc loc) {
                if (key.equals("name")) {
                    return new DatumTreeCallbackVisitor<String>(obj -> {
                        NSPatch.this.name = obj;
                    });
                }
                if (key.equals("sustainEnabled")) {
                    return new DatumTreeCallbackVisitor<Boolean>(obj -> {
                        NSPatch.this.sustainEnabled = obj;
                    });
                }
                if (key.equals("noiseEnabled")) {
                    return new DatumTreeCallbackVisitor<Boolean>(obj -> {
                        NSPatch.this.noiseEnabled = obj;
                    });
                }
                if (key.equals("strikeMs")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPatch.this.strikeMs = (int)obj.longValue();
                    });
                }
                if (key.equals("releaseMs")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPatch.this.releaseMs = (int)obj.longValue();
                    });
                }
                if (key.equals("fixedFrequency")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPatch.this.fixedFrequency = (int)obj.longValue();
                    });
                }
                if (key.equals("octaveShift")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPatch.this.octaveShift = (int)obj.longValue();
                    });
                }
                if (key.equals("mainWaveformSamples")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPatch.this.mainWaveformSamples = (int)obj.longValue();
                    });
                }
                if (key.equals("env")) {
                    return NSPatch.this.volumeWaveform.createDatumReadVisitor();
                }
                if (key.equals("wave")) {
                    return NSPatch.this.mainWaveform.createDatumReadVisitor();
                }
                if (key.equals("pitchEnv")) {
                    return NSPatch.this.pitchEnvWaveform.createDatumReadVisitor();
                }
                return DatumInvalidVisitor.INSTANCE;
            }
        });
    }
}

