/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import datum.DatumInvalidVisitor;
import datum.DatumSrcLoc;
import datum.DatumVisitor;
import datum.DatumWriter;
import gabien.datum.DatumKVDVisitor;
import gabien.datum.DatumTreeCallbackVisitor;
import gabien.media.midi.MIDISynthesizer;
import gabien.media.midi.newsynth.NSChannel;
import gabien.media.midi.newsynth.NSPatch;
import java.util.Arrays;
import java.util.LinkedList;

public class NSPalette
implements MIDISynthesizer.Palette {
    public final LinkedList<NSPatch> patches = new LinkedList();
    public final NSPatch[] programList = new NSPatch[256];

    @Override
    public MIDISynthesizer.Channel create(MIDISynthesizer parent, int bank, int program, int note, int velocity) {
        NSPatch resultingPatch;
        int baseProgram = 0;
        if (bank >= 128) {
            baseProgram = 128;
            program = note + 128;
        }
        if ((resultingPatch = this.programList[program]) == null) {
            resultingPatch = this.programList[baseProgram];
        }
        if (resultingPatch == null) {
            return null;
        }
        return new NSChannel(resultingPatch);
    }

    public void writeToDatum(DatumWriter writer) {
        for (NSPatch patch : this.patches) {
            writer.visitId("patch", DatumSrcLoc.NONE);
            patch.writeToDatum(writer);
            writer.visitNewline();
            for (int i = 0; i < this.programList.length; ++i) {
                if (this.programList[i] != patch) continue;
                writer.visitId("assign", DatumSrcLoc.NONE);
                writer.visitInt(i, DatumSrcLoc.NONE);
                writer.visitNewline();
            }
        }
    }

    public DatumVisitor createDatumReadVisitor() {
        this.patches.clear();
        Arrays.fill(this.programList, null);
        return new DatumKVDVisitor(){
            NSPatch lastPatch;

            @Override
            public DatumVisitor handle(String key, DatumSrcLoc loc) {
                if (key.equals("patch")) {
                    NSPatch newPatch;
                    this.lastPatch = newPatch = new NSPatch();
                    NSPalette.this.patches.add(newPatch);
                    return newPatch.createDatumReadVisitor();
                }
                if (key.equals("assign")) {
                    return new DatumTreeCallbackVisitor<Long>(obj -> {
                        NSPalette.this.programList[(int)obj.longValue()] = this.lastPatch;
                    });
                }
                return DatumInvalidVisitor.INSTANCE;
            }
        };
    }
}

