/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import gabien.media.midi.newsynth.IEditableCurveWaveform;

public class NSLoopedWaveform
implements IEditableCurveWaveform {
    public float[] pointData = new float[]{0.0f, 0.5f, 0.5f, 0.25f};

    @Override
    public int pointCount() {
        return this.pointData.length / 2;
    }

    @Override
    public boolean addPointRaw(int index) {
        if (index < 0) {
            return false;
        }
        if (index > this.pointData.length / 2) {
            return false;
        }
        float[] newPointArray = new float[this.pointData.length + 2];
        System.arraycopy(this.pointData, 0, newPointArray, 0, index << 1);
        System.arraycopy(this.pointData, index << 1, newPointArray, index + 1 << 1, this.pointData.length - (index << 1));
        this.pointData = newPointArray;
        return true;
    }

    @Override
    public void rmPoint(int index) {
        if (this.pointData.length <= 2) {
            return;
        }
        index = this.mapPointIdx(index);
        float[] newPointArray = new float[this.pointData.length - 2];
        System.arraycopy(this.pointData, 0, newPointArray, 0, index);
        System.arraycopy(this.pointData, index + 2, newPointArray, index, this.pointData.length - (index + 2));
        this.pointData = newPointArray;
    }

    private int mapPointIdx(int pointIdx) {
        int count = this.pointData.length / 2;
        while (pointIdx < 0) {
            pointIdx += count;
        }
        return pointIdx % count << 1;
    }

    private int mapPointGen(int pointIdx) {
        int count = this.pointData.length / 2;
        if (pointIdx < 0) {
            pointIdx -= count;
        }
        return pointIdx / count;
    }

    @Override
    public float pointX(int pointIdx) {
        return this.pointData[this.mapPointIdx(pointIdx)] + (float)this.mapPointGen(pointIdx);
    }

    @Override
    public float pointY(int pointIdx) {
        return this.pointData[this.mapPointIdx(pointIdx) + 1];
    }

    @Override
    public void movePoint(int pointIdx, float x, float y) {
        pointIdx = this.mapPointIdx(pointIdx);
        this.pointData[pointIdx] = x;
        this.pointData[pointIdx + 1] = y;
    }

    @Override
    public void importPoints(float[] data) {
        this.pointData = data;
    }
}

