/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import gabien.media.midi.MIDISynthesizer;
import gabien.media.midi.newsynth.NSPatch;
import gabien.uslx.append.MathsX;

public class NSChannel
extends MIDISynthesizer.Channel {
    float internalCounter;
    public float volume;
    public double timeInStage;
    public double renderTimeInStage;
    public double stageEndTime;
    public float pitchMulState;
    public int stage;
    public final NSPatch patch;
    public final float octaveShiftMultiplier;
    public final float[] waveform;
    public final float[] envelope;
    public final float[] pitchEnv;

    public NSChannel(NSPatch patch) {
        this.stageEndTime = (float)patch.strikeMs / 1000.0f;
        this.octaveShiftMultiplier = (float)Math.pow(2.0, patch.octaveShift);
        this.patch = patch;
        this.waveform = patch.getMainWaveform();
        this.envelope = patch.getEnvWaveform();
        this.pitchEnv = patch.getPitchEnvWaveform();
        this.pitchMulState = 1.0f;
        this.update(0.0);
    }

    @Override
    public void noteOffInner(int velocity) {
    }

    @Override
    public void render(float[] buffer, int offset, int frames, float leftVol, float rightVol) {
        float sampleSeconds = (float)this.getSampleSeconds();
        float effectiveCycleSeconds = (float)((this.patch.fixedFrequency != 0 ? 1.0 / (double)this.patch.fixedFrequency : this.getCycleSeconds()) / (double)this.pitchMulState);
        float sampleAdv = sampleSeconds / (effectiveCycleSeconds /= this.octaveShiftMultiplier) * (float)this.waveform.length;
        leftVol *= this.volume;
        rightVol *= this.volume;
        while (frames > 0) {
            this.internalCounter = (this.internalCounter + sampleAdv) % (float)this.waveform.length;
            float wf = MathsX.linearSample1d(this.internalCounter, this.waveform, true);
            int n = offset++;
            buffer[n] = buffer[n] + wf * leftVol;
            int n2 = offset++;
            buffer[n2] = buffer[n2] + wf * rightVol;
            --frames;
        }
    }

    @Override
    public boolean update(double time) {
        this.timeInStage += time;
        if (this.stage == 1 && !this.isNoteOn()) {
            this.timeInStage = this.stageEndTime;
        }
        while (this.timeInStage >= this.stageEndTime) {
            this.timeInStage -= this.stageEndTime;
            if (this.stage == 0) {
                if (this.patch.sustainEnabled) {
                    this.stage = 1;
                    this.stageEndTime = 3.4028234663852886E38;
                    continue;
                }
                this.stage = 2;
                this.stageEndTime = (float)this.patch.releaseMs / 1000.0f;
                continue;
            }
            if (this.stage == 1) {
                this.stage = 2;
                this.stageEndTime = (float)this.patch.releaseMs / 1000.0f;
                continue;
            }
            if (this.stage < 2) continue;
            this.stageEndTime = 1.4E-45f;
            return true;
        }
        int envQuarter = this.envelope.length / 4;
        float volPtr = MathsX.lerpUnclamped(0.0f, envQuarter, MathsX.clamp((float)(this.timeInStage / this.stageEndTime), 0.0f, 1.0f));
        if (this.stage == 0) {
            volPtr += (float)envQuarter;
        } else if (this.stage == 1) {
            volPtr = this.envelope.length / 2;
        } else if (this.stage == 2) {
            volPtr += (float)(this.envelope.length / 2);
        }
        this.volume = MathsX.linearSample1d(volPtr, this.envelope, false);
        this.pitchMulState = 0.5f + MathsX.linearSample1d(volPtr, this.pitchEnv, false);
        return false;
    }
}

