/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import datum.DatumInvalidVisitor;
import datum.DatumSrcLoc;
import datum.DatumVisitor;
import gabien.datum.DatumExpectListVisitor;
import gabien.media.midi.newsynth.ICurveWaveform;
import java.util.LinkedList;

public interface IEditableCurveWaveform
extends ICurveWaveform {
    public boolean addPointRaw(int var1);

    default public int addPoint(int index) {
        if (!this.addPointRaw(++index)) {
            return index - 1;
        }
        float prevX = this.pointX(index - 1);
        float nextX = this.pointX(index + 1);
        float prevY = this.pointY(index - 1);
        float nextY = this.pointY(index + 1);
        this.movePoint(index, Math.min(1.0f, Math.max(0.0f, (prevX + nextX) / 2.0f)), (prevY + nextY) / 2.0f);
        return index;
    }

    public void rmPoint(int var1);

    public void movePoint(int var1, float var2, float var3);

    public void importPoints(float[] var1);

    default public DatumVisitor createDatumReadVisitor() {
        return new DatumExpectListVisitor(() -> new DatumInvalidVisitor(){
            LinkedList flts = new LinkedList();

            @Override
            public void visitFloat(double value, DatumSrcLoc loc) {
                this.flts.add(Float.valueOf((float)value));
            }

            @Override
            public void visitInt(long value, DatumSrcLoc loc) {
                this.flts.add(Float.valueOf(value));
            }

            @Override
            public void visitEnd(DatumSrcLoc loc) {
                float[] res = new float[this.flts.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = ((Float)this.flts.get(i)).floatValue();
                }
                IEditableCurveWaveform.this.importPoints(res);
            }
        });
    }
}

