/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi.newsynth;

import gabien.media.midi.newsynth.ICurveWaveform;
import gabien.uslx.append.MathsX;
import java.util.Arrays;

public class CurvePlotter {
    public static void resolve(ICurveWaveform wave, float[] data, NormalizationMode normalized) {
        Arrays.fill(data, -2.0f);
        int pointCount = wave.pointCount();
        for (int i = -2; i < pointCount; i += 2) {
            float x1 = wave.pointX(i);
            float y1 = wave.pointY(i);
            float x2 = wave.pointX(i + 1);
            float y2 = wave.pointY(i + 1);
            float x3 = wave.pointX(i + 3);
            float y3 = wave.pointY(i + 3);
            float x4 = wave.pointX(i + 2);
            float y4 = wave.pointY(i + 2);
            x3 = x4 - (x3 - x4);
            y3 = y4 - (y3 - y4);
            CurvePlotter.plotCurve(data, x1, y1, x2, y2, x3, y3, x4, y4);
        }
        float lastRealValue = 0.0f;
        float total = 0.0f;
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        for (int j = 0; j < data.length; ++j) {
            float val = data[j];
            if (val == -2.0f) {
                val = lastRealValue;
            } else {
                lastRealValue = data[j];
            }
            data[j] = val;
            if (normalized == NormalizationMode.None) continue;
            total += val;
            min = Math.min(val, min);
            max = Math.max(val, max);
        }
        if (normalized != NormalizationMode.None) {
            float subtract = normalized == NormalizationMode.RecentreDC ? (total /= (float)data.length) : (max + min) / 2.0f;
            float vol = Math.max(0.01f, max - min) / 2.0f;
            for (int j = 0; j < data.length; ++j) {
                data[j] = (data[j] - subtract) / vol;
            }
        }
    }

    private static void plotCurve(float[] data, float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        int stepCount = data.length * 2;
        for (int step = 0; step < stepCount; ++step) {
            float lerpValue = (float)step / (float)stepCount;
            float xa = MathsX.lerpUnclamped(x1, x2, lerpValue);
            float ya = MathsX.lerpUnclamped(y1, y2, lerpValue);
            float xm = MathsX.lerpUnclamped(x2, x3, lerpValue);
            float ym = MathsX.lerpUnclamped(y2, y3, lerpValue);
            float xb = MathsX.lerpUnclamped(x3, x4, lerpValue);
            float yb = MathsX.lerpUnclamped(y3, y4, lerpValue);
            float xc = MathsX.lerpUnclamped(xa, xm, lerpValue);
            float yc = MathsX.lerpUnclamped(ya, ym, lerpValue);
            float xd = MathsX.lerpUnclamped(xm, xb, lerpValue);
            float yd = MathsX.lerpUnclamped(ym, yb, lerpValue);
            float x = MathsX.lerpUnclamped(xc, xd, lerpValue);
            float y = MathsX.lerpUnclamped(yc, yd, lerpValue);
            int xInt = (int)(x * (float)data.length);
            if (xInt < 0 || xInt >= data.length) continue;
            data[xInt] = y;
        }
    }

    private static void debugPlot(float[] data, float x, float y) {
        int xInt = (int)(x * (float)data.length);
        if (xInt < 0 || xInt >= data.length) {
            return;
        }
        data[xInt] = y;
    }

    public static enum NormalizationMode {
        None,
        RecentreDC,
        RecentreMinmax;

    }
}

