/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi;

public class MIDIUtils {
    public static int getVLI(byte[] data, int offset) {
        int b;
        int v = 0;
        do {
            b = data[offset++] & 0xFF;
            v <<= 7;
            v |= b & 0x7F;
        } while ((b & 0x80) != 0);
        return v;
    }

    public static int getVLILength(byte[] data, int offset) {
        int b;
        int len = 0;
        do {
            ++len;
        } while (((b = data[offset++] & 0xFF) & 0x80) != 0);
        return len;
    }

    public static int getEventDataLen(byte status, byte[] data, int offset) {
        int b = status & 0xFF;
        if (b >= 128 && b <= 191) {
            return 2;
        }
        if (b >= 192 && b <= 223) {
            return 1;
        }
        if (b >= 224 && b <= 239) {
            return 2;
        }
        if (b == 240 || b == 247) {
            return MIDIUtils.getVLILength(data, offset) + MIDIUtils.getVLI(data, offset);
        }
        if (b == 241) {
            return 1;
        }
        if (b == 242) {
            return 2;
        }
        if (b == 243) {
            return 1;
        }
        if (b == 255) {
            return 1 + MIDIUtils.getVLILength(data, offset + 1) + MIDIUtils.getVLI(data, offset + 1);
        }
        return 0;
    }

    public static double getNoteHz(double note) {
        return 55.0 * Math.pow(2.0, (note - 33.0) / 12.0);
    }
}

