/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi;

import gabien.media.midi.MIDIEventReceiver;
import gabien.media.midi.MIDISequence;
import gabien.media.midi.MIDITimableThing;
import gabien.media.midi.MIDIUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MIDITracker
implements MIDITimableThing {
    private final MIDISequence sequence;
    private final int[] pointers;
    private final int[] eventTicks;
    private int tickOfNextEvent = -1;
    private int currentTick = 0;
    private final byte[] runningStatus;
    private double deltaTimeToSeconds;
    @Nullable
    public MIDIEventReceiver receiver;

    public MIDITracker(@NonNull MIDISequence s, @Nullable MIDIEventReceiver receiver) {
        this.receiver = receiver;
        this.sequence = s;
        this.pointers = new int[s.tracks.length];
        this.eventTicks = new int[s.tracks.length];
        this.runningStatus = new byte[s.tracks.length];
        this.dtuByTempo(500000);
        for (int i = 0; i < this.pointers.length; ++i) {
            this.readDeltaTime(i);
        }
        this.recalculateTickOfNextEvent();
    }

    private void dtuByTempo(int tempo) {
        if (this.sequence.division < 0) {
            int tca = this.sequence.division >> 8;
            int tcb = this.sequence.division & 0xFF;
            int fps = 30;
            if (tca == -24) {
                fps = 24;
            } else if (tca == 25) {
                fps = 25;
            }
            this.deltaTimeToSeconds = 1.0 / (double)(tcb * fps);
        } else {
            this.deltaTimeToSeconds = (double)tempo / (1000000.0 * (double)this.sequence.division);
        }
    }

    private void readDeltaTime(int track) {
        if (this.pointers[track] >= this.sequence.tracks[track].length) {
            this.eventTicks[track] = -1;
            return;
        }
        this.eventTicks[track] = this.currentTick + MIDIUtils.getVLI(this.sequence.tracks[track], this.pointers[track]);
        int n = track;
        this.pointers[n] = this.pointers[n] + MIDIUtils.getVLILength(this.sequence.tracks[track], this.pointers[track]);
    }

    private void recalculateTickOfNextEvent() {
        this.tickOfNextEvent = -1;
        for (int i = 0; i < this.pointers.length; ++i) {
            int rt = this.eventTicks[i];
            if (rt == -1 || this.tickOfNextEvent != -1 && this.tickOfNextEvent <= rt) continue;
            this.tickOfNextEvent = rt;
        }
    }

    @Override
    public double getTicksToSeconds() {
        return this.deltaTimeToSeconds;
    }

    @Override
    public int getCurrentTick() {
        return this.currentTick;
    }

    @Override
    public int getTickOfNextEvent() {
        return this.tickOfNextEvent;
    }

    private void doInternalReceiveEvent(byte status, byte[] data, int offset, int length) {
        int vlil;
        if (status == -1 && data[offset] == 81 && length >= (vlil = MIDIUtils.getVLILength(data, offset + 1)) + 4) {
            int a = data[offset + vlil + 1] & 0xFF;
            int b = data[offset + vlil + 2] & 0xFF;
            int c = data[offset + vlil + 3] & 0xFF;
            int res = a << 16 | b << 8 | c;
            this.dtuByTempo(res);
        }
    }

    @Override
    public boolean runNextEvent() {
        if (this.currentTick != this.tickOfNextEvent) {
            if (this.tickOfNextEvent == -1) {
                return false;
            }
            this.currentTick = this.tickOfNextEvent;
        }
        for (int i = 0; i < this.pointers.length; ++i) {
            if (this.currentTick != this.eventTicks[i]) continue;
            byte status = this.sequence.tracks[i][this.pointers[i]];
            if (status < 0) {
                if (status < -8) {
                    this.runningStatus[i] = status;
                }
                int n = i;
                this.pointers[n] = this.pointers[n] + 1;
            } else {
                status = this.runningStatus[i];
            }
            int remaining = this.sequence.tracks[i].length - this.pointers[i];
            int dataLen = MIDIUtils.getEventDataLen(status, this.sequence.tracks[i], this.pointers[i]);
            if (dataLen > remaining) {
                dataLen = remaining;
            }
            this.doInternalReceiveEvent(status, this.sequence.tracks[i], this.pointers[i], dataLen);
            if (this.receiver != null) {
                this.receiver.receiveEvent(status, this.sequence.tracks[i], this.pointers[i], dataLen);
            }
            int n = i;
            this.pointers[n] = this.pointers[n] + dataLen;
            this.readDeltaTime(i);
        }
        this.recalculateTickOfNextEvent();
        return true;
    }
}

