/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi;

import gabien.media.midi.MIDITimableThing;
import org.eclipse.jdt.annotation.NonNull;

public class MIDITimer {
    public final MIDITimableThing target;
    public double currentTime;
    private double lastBase;
    private double lastBaseTTS;
    private int lastBaseTick;

    public MIDITimer(@NonNull MIDITimableThing target) {
        this.target = target;
        this.lastBaseTTS = target.getTicksToSeconds();
    }

    public void resolveTick(int targetTick) {
        int currentTick = this.target.getCurrentTick();
        while (currentTick < targetTick) {
            this.runAllEventsSlatedForNow();
            int nextEventAt = this.target.getCurrentTick();
            if (nextEventAt == -1 || nextEventAt > targetTick) break;
            currentTick = nextEventAt;
            this.target.runNextEvent();
            this.updateBaseIfNecessary();
        }
        this.currentTime = this.lastBase + (double)(currentTick - this.lastBaseTick) * this.lastBaseTTS;
    }

    private void runAllEventsSlatedForNow() {
        int currentTick = this.target.getCurrentTick();
        while (currentTick == this.target.getTickOfNextEvent()) {
            this.target.runNextEvent();
        }
        this.updateBaseIfNecessary();
    }

    private void updateBaseIfNecessary() {
        double currentTicksToSeconds = this.target.getTicksToSeconds();
        if (currentTicksToSeconds != this.lastBaseTTS) {
            int currentTick = this.target.getCurrentTick();
            this.lastBase += this.lastBaseTTS * (double)(currentTick - this.lastBaseTick);
            this.lastBaseTTS = currentTicksToSeconds;
            this.lastBaseTick = currentTick;
        }
    }

    public void resolve() {
        double nextTime;
        this.runAllEventsSlatedForNow();
        int targetTick = this.target.getTickOfNextEvent();
        while (targetTick != -1 && !(this.currentTime < (nextTime = this.lastBase + (double)(targetTick - this.lastBaseTick) * this.lastBaseTTS))) {
            this.target.runNextEvent();
            this.updateBaseIfNecessary();
            this.runAllEventsSlatedForNow();
            targetTick = this.target.getTickOfNextEvent();
        }
    }
}

