/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi;

import gabien.media.midi.MIDIEventReceiver;
import gabien.media.midi.MIDIUtils;
import org.eclipse.jdt.annotation.NonNull;

public final class MIDISynthesizer
implements MIDIEventReceiver {
    public static final float DEFAULT_GLOBAL_VOLUME = 1.0f;
    public final int sampleRate;
    public final double sampleTime;
    public float globalVolume = 1.0f;
    private final Palette pal;
    public final MIDIChannel[] midiChannels = new MIDIChannel[16];

    public MIDISynthesizer(int rate, @NonNull Palette pal, int capacity) {
        this.sampleRate = rate;
        this.sampleTime = 1.0 / (double)rate;
        this.pal = pal;
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i] = new MIDIChannel(capacity);
        }
        this.resetParameters();
    }

    public void resetParameters() {
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].bank = 0;
            this.midiChannels[i].program = 0;
            this.midiChannels[i].volume = 1.0f;
            this.midiChannels[i].pan = 0.5f;
        }
        this.midiChannels[9].bank = 128;
    }

    @Override
    public void receiveEvent(byte status, byte[] data, int offset, int length) {
        int si = status & 0xFF;
        int mch = si & 0xF;
        if (si >= 128 && si <= 143 && length >= 2) {
            this.midiChannels[mch].noteOff(data[offset] & 0x7F, data[offset + 1] & 0x7F);
        } else if (si >= 144 && si <= 159 && length >= 2) {
            this.midiChannels[mch].noteOn(data[offset] & 0x7F, data[offset + 1] & 0x7F);
        } else if (si >= 176 && si <= 191 && length >= 2) {
            int cc = data[offset] & 0x7F;
            int cv = data[offset + 1] & 0x7F;
            if (cc == 0) {
                this.midiChannels[mch].bank = mch == 9 ? cv | 0x80 : cv;
            } else if (cc == 7) {
                this.midiChannels[mch].volume = (float)cv / 127.0f;
            } else if (cc == 8 || cc == 10) {
                float pan = cv == 64 ? 0.5f : (float)cv / 127.0f;
                this.midiChannels[mch].pan = (pan * 2.0f + 0.5f) / 3.0f;
            } else if (cc == 123) {
                this.midiChannels[mch].noteOffAll();
            }
        } else if (si >= 192 && si <= 207 && length >= 1) {
            this.midiChannels[mch].program = data[offset] & 0x7F;
        } else if (si >= 224 && si <= 239 && length >= 2) {
            int val = data[offset] & 0x7F;
            val |= (data[offset + 1] & 0x7F) << 7;
            this.midiChannels[mch].setPitchBend((double)(val -= 8192) / 4096.0);
        }
    }

    public void clear() {
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].clear();
        }
    }

    public void render(float[] buffer, int offset, int frames) {
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].render(buffer, offset, frames);
        }
    }

    public void update(double time) {
        for (int i = 0; i < 16; ++i) {
            this.midiChannels[i].update(time);
        }
    }

    public static abstract class Channel {
        private boolean noteOn = true;
        private int savedNote;
        private int sampleRate;
        private double frequency;
        private double cycleSeconds;
        private double halfCycleSeconds;
        private double sampleSeconds;
        private float extLVol;
        private float extRVol;
        private int age;

        public final double getFrequencyHz() {
            return this.frequency;
        }

        public final double getCycleSeconds() {
            return this.cycleSeconds;
        }

        public final double getHalfCycleSeconds() {
            return this.halfCycleSeconds;
        }

        public final int getSampleRate() {
            return this.sampleRate;
        }

        public final double getSampleSeconds() {
            return this.sampleSeconds;
        }

        public final void setPitchBend(double pitchBend) {
            this.frequency = MIDIUtils.getNoteHz((double)this.savedNote + pitchBend);
            this.cycleSeconds = 1.0 / this.frequency;
            this.halfCycleSeconds = 0.5 / this.frequency;
        }

        public final boolean isNoteOn() {
            return this.noteOn;
        }

        public final void noteOff(int velocity) {
            this.noteOn = false;
            this.noteOffInner(velocity);
        }

        public abstract void noteOffInner(int var1);

        public abstract void render(float[] var1, int var2, int var3, float var4, float var5);

        public abstract boolean update(double var1);
    }

    public static interface Palette {
        public Channel create(MIDISynthesizer var1, int var2, int var3, int var4, int var5);
    }

    public final class MIDIChannel {
        public boolean enabled = true;
        public int bank;
        public int program;
        public float volume;
        public float pan;
        private final Channel[] synthChannels;
        private final Channel[] noteChannels = new Channel[128];
        private double savedPitchBend;
        private int channelAgeCounter;

        private MIDIChannel(int capacity) {
            this.synthChannels = new Channel[capacity];
        }

        public void setPitchBend(double val) {
            this.savedPitchBend = val;
            for (int i = 0; i < this.synthChannels.length; ++i) {
                if (this.synthChannels[i] == null) continue;
                this.synthChannels[i].setPitchBend(this.savedPitchBend);
            }
        }

        public void noteOn(int note, int velocity) {
            if (this.noteChannels[note] != null) {
                this.noteChannels[note].noteOff(127);
            }
            if (!this.enabled) {
                return;
            }
            Channel target = MIDISynthesizer.this.pal.create(MIDISynthesizer.this, this.bank, this.program, note, velocity);
            if (target == null) {
                return;
            }
            target.age = this.channelAgeCounter++;
            float velocityVol = (float)velocity / 127.0f * this.volume;
            float cPanL = 1.0f - this.pan;
            float cPanR = this.pan;
            float panCMul = (float)(1.0 / Math.sqrt(cPanL * cPanL + cPanR * cPanR));
            target.extLVol = velocityVol * panCMul;
            target.extRVol = velocityVol * panCMul;
            target.savedNote = note;
            target.sampleRate = MIDISynthesizer.this.sampleRate;
            target.sampleSeconds = MIDISynthesizer.this.sampleTime;
            target.setPitchBend(this.savedPitchBend);
            target.update(0.0);
            this.noteChannels[note] = target;
            for (int i = 0; i < this.synthChannels.length; ++i) {
                if (this.synthChannels[i] != null) continue;
                this.synthChannels[i] = target;
                return;
            }
            int age = Integer.MAX_VALUE;
            int ageIndex = 0;
            for (int i = 0; i < this.synthChannels.length; ++i) {
                if (this.synthChannels[i].age > age) continue;
                age = this.synthChannels[i].age;
                ageIndex = i;
            }
            this.synthChannels[ageIndex] = target;
        }

        public void noteOff(int note, int velocity) {
            if (this.noteChannels[note] != null) {
                this.noteChannels[note].noteOff(velocity);
            }
        }

        public void noteOffAll() {
            for (Channel c : this.noteChannels) {
                if (c == null) continue;
                c.noteOff(127);
            }
        }

        public void clear() {
            int i;
            for (i = 0; i < this.noteChannels.length; ++i) {
                this.noteChannels[i] = null;
            }
            for (i = 0; i < this.synthChannels.length; ++i) {
                this.synthChannels[i] = null;
            }
        }

        public void render(float[] buffer, int offset, int frames) {
            for (Channel c : this.synthChannels) {
                if (c == null) continue;
                c.render(buffer, offset, frames, c.extLVol * MIDISynthesizer.this.globalVolume, c.extRVol * MIDISynthesizer.this.globalVolume);
            }
        }

        public void update(double time) {
            for (int i = 0; i < this.synthChannels.length; ++i) {
                if (this.synthChannels[i] == null || !this.synthChannels[i].update(time)) continue;
                this.synthChannels[i] = null;
            }
        }

        public int getActivity() {
            int activity = 0;
            for (int i = 0; i < this.synthChannels.length; ++i) {
                if (this.synthChannels[i] == null) continue;
                ++activity;
            }
            return activity;
        }
    }
}

