/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.midi;

import gabien.media.midi.MIDITracker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;

public final class MIDISequence {
    public final short division;
    public final byte[][] tracks;

    public MIDISequence(short div, byte[][] tracks) {
        this.division = div;
        this.tracks = tracks;
    }

    public static MIDISequence[] from(InputStream inp) throws IOException {
        DataInputStream dis = new DataInputStream(inp);
        if (dis.readInt() != 1297377380) {
            throw new IOException("not MThd");
        }
        if (dis.readInt() != 6) {
            throw new IOException("MThd should have 6 bytes");
        }
        int fmt = dis.readUnsignedShort();
        int trk = dis.readUnsignedShort();
        short div = dis.readShort();
        byte[][] trks = new byte[trk][];
        for (int i = 0; i < trk; ++i) {
            if (dis.readInt() != 1297379947) {
                throw new IOException("not MTrk");
            }
            int len = dis.readInt();
            byte[] trkData = new byte[len];
            dis.readFully(trkData);
            trks[i] = trkData;
        }
        if (fmt == 2) {
            MIDISequence[] res = new MIDISequence[trks.length];
            for (int i = 0; i < res.length; ++i) {
                res[i] = new MIDISequence(div, new byte[][]{trks[i]});
            }
            return res;
        }
        return new MIDISequence[]{new MIDISequence(div, trks)};
    }

    public void exportSequenceFile(OutputStream outp) throws IOException {
        DataOutputStream dos = new DataOutputStream(outp);
        MIDISequence.writeHeader(dos, 0, this.tracks.length, this.division);
        for (int i = 0; i < this.tracks.length; ++i) {
            dos.writeInt(1297379947);
            dos.writeInt(this.tracks[i].length);
            dos.write(this.tracks[i]);
        }
    }

    public static void writeHeader(DataOutputStream outp, int fmt, int trk, int div) throws IOException {
        DataOutputStream dos = new DataOutputStream(outp);
        dos.writeInt(1297377380);
        dos.writeInt(6);
        dos.writeShort(fmt);
        dos.writeShort(trk);
        dos.writeShort(div);
    }

    public TimingInformation calcTimingInformation() {
        int tick;
        MIDITracker mt = new MIDITracker(this, null);
        while (mt.getTickOfNextEvent() == 0) {
            mt.runNextEvent();
        }
        LinkedList<TimingSegment> ll = new LinkedList<TimingSegment>();
        TimingSegment lastBase = new TimingSegment(0, 0.0, mt.getTicksToSeconds());
        ll.add(lastBase);
        int lastTick = 0;
        while ((tick = mt.getTickOfNextEvent()) != -1) {
            lastTick = tick;
            mt.runNextEvent();
            double newTTS = mt.getTicksToSeconds();
            if (newTTS == lastBase.ticksToSeconds) continue;
            lastBase = new TimingSegment(tick, (double)(tick - lastBase.startTick) * lastBase.ticksToSeconds, newTTS);
            ll.add(lastBase);
        }
        return new TimingInformation(ll.toArray(new TimingSegment[0]), lastTick);
    }

    public static class TimingSegment {
        public final int startTick;
        public final double startTime;
        public final double ticksToSeconds;

        public TimingSegment(int startTick, double startTime, double ticksToSeconds) {
            this.startTick = startTick;
            this.startTime = startTime;
            this.ticksToSeconds = ticksToSeconds;
        }
    }

    public static class TimingInformation {
        public final TimingSegment[] segments;
        public final int lastTick;
        public final double lengthSeconds;

        public TimingInformation(TimingSegment[] segments, int lastTick) {
            if (segments[0] == null || segments[0].startTick != 0 || segments[0].startTime != 0.0) {
                throw new RuntimeException("Missing or invalid TimingInformation opening segment");
            }
            this.segments = segments;
            this.lastTick = lastTick;
            double totalLength = 0.0;
            int at = 0;
            double currentTTS = 1.0;
            for (TimingSegment ts : segments) {
                if (ts.startTick > lastTick) {
                    totalLength += currentTTS * (double)(lastTick - at);
                    break;
                }
                totalLength += currentTTS * (double)(ts.startTick - at);
                at = ts.startTick;
                currentTTS = ts.ticksToSeconds;
            }
            this.lengthSeconds = totalLength += currentTTS * (double)(lastTick - at);
        }

        public int secondsToTick(double d) {
            int candidate = 0;
            for (TimingSegment s : this.segments) {
                if (!(d >= s.startTime)) continue;
                candidate = s.startTick + (int)Math.floor((d - s.startTime) / s.ticksToSeconds);
            }
            return candidate;
        }
    }
}

