/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio.fileio;

import gabien.media.audio.AudioIOCRFmt;
import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSource;
import gabien.media.riff.RIFFInputStream;
import gabien.media.riff.RIFFOutputStream;
import gabien.uslx.io.LEDataInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class WavIO {
    public static AudioIOSource readWAV(@NonNull InputStream fis, boolean close) throws IOException {
        RIFFInputStream ris = new RIFFInputStream(fis);
        ris.readListOrRiffTypeAndVerify("WAVE", "wave");
        return WavIO.readWAVInterior(ris, close ? fis : null);
    }

    public static AudioIOSource readWAVInterior(@NonNull RIFFInputStream ris, @Nullable Closeable closeMe) throws IOException {
        AudioIOCRFmt fmt = null;
        while (ris.available() > 0) {
            RIFFInputStream chk = new RIFFInputStream(ris);
            if (chk.chunkId.equals("fmt ")) {
                fmt = WavIO.readFMT(chk);
            } else if (chk.chunkId.equals("data")) {
                if (fmt == null) {
                    throw new IOException("Got 'data' chunk before 'fmt ' chunk");
                }
                return WavIO.readDATA(chk, fmt, closeMe);
            }
            chk.close();
        }
        throw new IOException("Never found 'data' chunk");
    }

    public static AudioIOCRFmt readFMT(@NonNull LEDataInputStream fmtChk) throws IOException {
        int fmtTag = fmtChk.readUnsignedShort();
        int channels = fmtChk.readUnsignedShort();
        int channelMask = 0;
        int sampleRate = fmtChk.readInt();
        fmtChk.readInt();
        fmtChk.readUnsignedShort();
        int sampleBits = fmtChk.readUnsignedShort();
        if (fmtTag == 65534) {
            if (fmtChk.readUnsignedShort() < 22) {
                throw new IOException("Extensible WAVE format, but not enough header for it");
            }
            fmtChk.readShort();
            channelMask = fmtChk.readInt();
            fmtTag = fmtChk.readUnsignedShort();
        }
        return new AudioIOCRFmt(AudioIOFormat.detect(fmtTag, sampleBits), channels, channelMask, sampleRate);
    }

    public static AudioIOSource readDATA(final @NonNull RIFFInputStream data, @NonNull AudioIOCRFmt fmt, final @Nullable Closeable closeMe) throws IOException {
        final int frameBytes = fmt.format.bytesPerSample * fmt.channels;
        final int frameCount = data.chunkLen / frameBytes;
        return new AudioIOSource.SourceBytes(fmt, fmt.format){

            @Override
            public int frameCount() {
                return frameCount;
            }

            @Override
            public void nextFrames(@NonNull byte[] frame, int at, int frames) throws IOException {
                data.readFully(frame, at, frameBytes * frames);
            }

            @Override
            public void close() throws IOException {
                if (closeMe != null) {
                    closeMe.close();
                }
            }
        };
    }

    public static void writeWAV(@NonNull OutputStream fos, @NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt) throws IOException {
        int interiorContent = 4 + WavIO.sizeWAVInterior(dataSource, fmt);
        RIFFOutputStream riffChunk = new RIFFOutputStream(fos, "RIFF", interiorContent);
        riffChunk.writeBytes("WAVE");
        WavIO.writeWAVInterior(riffChunk, dataSource, fmt);
        riffChunk.close();
        dataSource.close();
    }

    public static void writeWAVInterior(@NonNull OutputStream fos, @NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt) throws IOException {
        int requirements = WavIO.inferFullRequirements(dataSource, fmt);
        int fmtSize = WavIO.fmtSizeFromRequirements(requirements);
        WavIO.writeWAVInteriorFMT(fos, dataSource, fmt, fmtSize);
        if ((requirements & 1) != 0) {
            WavIO.writeWAVInteriorFACT(fos, dataSource);
        }
        WavIO.writeWAVInteriorDATA(fos, dataSource, fmt);
    }

    public static int sizeWAVInterior(@NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt) throws IOException {
        AudioIOCRSet cr = dataSource.crSet;
        int frameCount = dataSource.frameCount();
        int frameBytes = cr.channels * fmt.bytesPerSample;
        int totalSampleBytes = frameCount * frameBytes;
        int requirements = WavIO.inferFullRequirements(dataSource, fmt);
        int fmtSize = WavIO.fmtSizeFromRequirements(requirements);
        int interiorContent = 0;
        interiorContent += RIFFOutputStream.getInteriorChunkSize(fmtSize);
        if ((requirements & 1) != 0) {
            interiorContent += RIFFOutputStream.getInteriorChunkSize(4);
        }
        return interiorContent += RIFFOutputStream.getInteriorChunkSize(totalSampleBytes);
    }

    public static void writeWAVInteriorFMT(@NonNull OutputStream fos, @NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt, int fmtSize) throws IOException {
        block15: {
            AudioIOCRSet cr = dataSource.crSet;
            try (RIFFOutputStream fmtChunk = new RIFFOutputStream(fos, "fmt ", fmtSize);){
                fmtChunk.writeShort(fmtSize == 40 ? 65534 : fmt.formatCode);
                fmtChunk.writeShort(cr.channels);
                fmtChunk.writeInt(cr.sampleRate);
                fmtChunk.writeInt(cr.sampleRate * fmt.bytesPerSample * cr.channels);
                fmtChunk.writeShort(fmt.bytesPerSample * cr.channels);
                fmtChunk.writeShort(fmt.bitsPerSample);
                if (fmtSize == 16) {
                    break block15;
                }
                if (fmtSize == 18) {
                    fmtChunk.writeShort(0);
                    break block15;
                }
                if (fmtSize == 40) {
                    fmtChunk.writeShort(22);
                    fmtChunk.writeShort(fmt.bitsPerSample);
                    fmtChunk.writeInt(cr.channelMask);
                    fmtChunk.writeInt(fmt.formatCode);
                    fmtChunk.writeInt(0);
                    fmtChunk.writeLong(0L);
                    break block15;
                }
                throw new UnsupportedOperationException("How'd you do this then, hmm?");
            }
        }
    }

    public static void writeWAVInteriorFACT(@NonNull OutputStream fos, @NonNull AudioIOSource dataSource) throws IOException {
        int frameCount = dataSource.frameCount();
        RIFFOutputStream factChunk = new RIFFOutputStream(fos, "fact", 4);
        factChunk.writeInt(frameCount);
        factChunk.close();
    }

    public static void writeWAVInteriorDATA(@NonNull OutputStream fos, @NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt) throws IOException {
        int framesToWrite;
        AudioIOCRSet cr = dataSource.crSet;
        int frameCount = dataSource.frameCount();
        int frameBytes = cr.channels * fmt.bytesPerSample;
        int totalSampleBytes = frameCount * frameBytes;
        RIFFOutputStream dataChunk = new RIFFOutputStream(fos, "data", totalSampleBytes);
        int framesPerWrite = cr.sampleRate;
        byte[] data = new byte[frameBytes * framesPerWrite];
        for (int i = 0; i < frameCount; i += framesToWrite) {
            framesToWrite = frameCount - i;
            if (framesToWrite > framesPerWrite) {
                framesToWrite = framesPerWrite;
            }
            dataSource.nextFramesInFormat(fmt, data, 0, framesToWrite);
            dataChunk.write(data, 0, frameBytes * framesToWrite);
        }
        dataChunk.close();
    }

    private static int inferFullRequirements(@NonNull AudioIOSource dataSource, @NonNull AudioIOFormat fmt) throws IOException {
        int requirements = fmt.requirements;
        if (dataSource.crSet.channelMask != 0) {
            requirements |= 4;
        }
        if ((requirements & 4) != 0) {
            requirements |= 2;
            requirements |= 1;
        }
        return requirements;
    }

    private static int fmtSizeFromRequirements(int requirements) throws IOException {
        int fmtSize = 16;
        if ((requirements & 2) != 0) {
            fmtSize = 18;
        }
        if ((requirements & 4) != 0) {
            fmtSize = 40;
        }
        return fmtSize;
    }
}

