/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio.fileio;

import gabien.media.audio.AudioIOSource;
import gabien.media.audio.fileio.MIDISynthesizerSource;
import gabien.media.audio.fileio.MP3Source;
import gabien.media.audio.fileio.OggVorbisSource;
import gabien.media.audio.fileio.WavIO;
import gabien.media.midi.DefaultMIDIPalette;
import gabien.media.midi.MIDISequence;
import gabien.media.midi.MIDISynthesizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public abstract class ReadAnySupportedAudioSource {
    public static int MIDI_POLYPHONY = 32;

    private ReadAnySupportedAudioSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioIOSource open(InputStream inp, boolean close) throws IOException {
        PushbackInputStream pb = new PushbackInputStream(inp);
        int b = pb.read();
        if (b == -1) {
            throw new IOException("Empty file");
        }
        pb.unread(b);
        if (b == 79) {
            return OggVorbisSource.fromInputStream(pb, close);
        }
        if (b == 82) {
            return WavIO.readWAV(pb, close);
        }
        if (b == 77) {
            MIDISequence[] ms;
            try {
                ms = MIDISequence.from(pb);
            }
            finally {
                if (close) {
                    pb.close();
                }
            }
            if (ms.length == 0) {
                throw new IOException("MIDI without tracks!");
            }
            DefaultMIDIPalette.initialize();
            MIDISynthesizer synth = new MIDISynthesizer(22050, DefaultMIDIPalette.INSTANCE, MIDI_POLYPHONY);
            return new MIDISynthesizerSource(ms[0], synth, 2.0);
        }
        return MP3Source.fromInputStream(inp, close);
    }
}

