/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio.fileio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOSource;
import gabien.media.ogg.OggBufferedDemux;
import gabien.media.ogg.OggBufferingInputStreamReader;
import gabien.natives.VorbisDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.eclipse.jdt.annotation.NonNull;

public class OggVorbisSource
extends AudioIOSource.SourceF32 {
    private final VorbisDecoder res;
    private final int frameCount;
    int framesToDiscard;
    private final LinkedList<byte[]> packets;
    private final float[] buffer;
    private int bufferPosition = 0;
    private int bufferRemainingFrames = 0;

    private OggVorbisSource(VorbisDecoder res, LinkedList<byte[]> packets, long igp) throws IOException {
        super(new AudioIOCRSet(res.channels, res.sampleRate));
        this.res = res;
        this.packets = packets;
        this.buffer = new float[res.outputLength];
        if (igp < 0L) {
            this.framesToDiscard = (int)(-igp);
        }
        boolean isFirst = true;
        int tfc = 0;
        for (byte[] b : packets) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            tfc += res.getPacketSampleCount(b, 0, b.length);
        }
        this.frameCount = tfc -= this.framesToDiscard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OggVorbisSource fromInputStream(InputStream inp, boolean close) throws IOException {
        try {
            OggBufferedDemux demux = new OggBufferedDemux();
            OggBufferingInputStreamReader isr = new OggBufferingInputStreamReader(inp, demux);
            isr.readStartingBOSPages();
            OggBufferedDemux.Stream stream = null;
            for (OggBufferedDemux.Stream st : demux.streams) {
                byte[] packet1;
                if (st.packets.size() <= 0 || (packet1 = st.packets.getFirst()).length < 7 || packet1[0] != 1 || packet1[1] != 118 || packet1[2] != 111 || packet1[3] != 114 || packet1[4] != 98 || packet1[5] != 105 || packet1[6] != 115) continue;
                stream = st;
                break;
            }
            if (stream == null) {
                throw new IOException("No Vorbis stream could be identified from the BOS pages.");
            }
            isr.out = stream;
            LinkedList<byte[]> packets = stream.packets;
            while (packets.size() < 4) {
                if (isr.readNextPage()) continue;
                throw new IOException("Was unable to get header packets and a single data packet");
            }
            long initGranulePos = stream.lastGranulePos;
            while (isr.readNextPage()) {
            }
            byte[] id = packets.removeFirst();
            packets.removeFirst();
            byte[] setup = packets.removeFirst();
            VorbisDecoder res = new VorbisDecoder(id, 0, id.length, setup, 0, setup.length);
            OggVorbisSource oggVorbisSource = new OggVorbisSource(res, packets, initGranulePos);
            return oggVorbisSource;
        }
        finally {
            if (close) {
                inp.close();
            }
        }
    }

    @Override
    public int frameCount() {
        return this.frameCount;
    }

    @Override
    public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
        while (frames > 0) {
            if (this.bufferRemainingFrames > 0) {
                if (this.framesToDiscard > 0) {
                    this.bufferPosition += this.res.channels;
                } else {
                    for (int i = 0; i < this.res.channels; ++i) {
                        frame[at++] = this.buffer[this.bufferPosition++];
                    }
                    --frames;
                }
                --this.bufferRemainingFrames;
                continue;
            }
            if (this.packets.size() > 0) {
                this.bufferPosition = 0;
                byte[] packet = this.packets.removeFirst();
                this.bufferRemainingFrames = this.res.decodeFrame(packet, 0, packet.length, this.buffer, 0);
                continue;
            }
            throw new EOFException("Out of frames!");
        }
    }
}

