/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio.fileio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOSource;
import gabien.natives.MP3Decoder;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;

public class MP3Source
extends AudioIOSource.SourceF32 {
    private final MP3Decoder res;
    private final int frameCount;
    private final byte[] data;
    private int dataPosition = 0;
    private final float[] buffer = new float[2304];
    private int bufferPosition = 0;
    private int bufferRemainingFrames = 0;

    private MP3Source(MP3Decoder res, int channels, int sampleRate, int frameCount, byte[] data) throws IOException {
        super(new AudioIOCRSet(channels, sampleRate));
        this.res = res;
        this.data = data;
        this.frameCount = frameCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MP3Source fromInputStream(InputStream inp, boolean close) throws IOException {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] chk = new byte[4096];
            while ((len = inp.read(chk)) >= 0) {
                baos.write(chk, 0, len);
            }
            byte[] data = baos.toByteArray();
            baos = null;
            boolean isFirst = true;
            int frameCount = 0;
            int sampleRate = 22050;
            int channels = 1;
            int dataPosition = 0;
            MP3Decoder res = new MP3Decoder();
            while (true) {
                int frames;
                if ((frames = res.decodeFrame(data, dataPosition, data.length - dataPosition, null, 0)) == 0) {
                    if ((dataPosition += 4096) < data.length) continue;
                    break;
                }
                frameCount += frames;
                if (isFirst) {
                    sampleRate = res.getLastFrameSampleRate();
                    channels = res.getLastFrameChannels();
                    isFirst = false;
                }
                dataPosition += res.getLastFrameBytes();
            }
            if (frameCount == 0) {
                res.close();
                throw new IOException("Not an MP3");
            }
            res.reset();
            MP3Source mP3Source = new MP3Source(res, channels, sampleRate, frameCount, data);
            return mP3Source;
        }
        finally {
            if (close) {
                inp.close();
            }
        }
    }

    @Override
    public int frameCount() {
        return this.frameCount;
    }

    @Override
    public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
        while (frames > 0) {
            block4: {
                if (this.bufferRemainingFrames > 0) {
                    for (int i = 0; i < this.crSet.channels; ++i) {
                        frame[at++] = this.buffer[this.bufferPosition++];
                    }
                    --frames;
                    --this.bufferRemainingFrames;
                    continue;
                }
                this.bufferPosition = 0;
                do {
                    this.bufferRemainingFrames = this.res.decodeFrame(this.data, this.dataPosition, this.data.length - this.dataPosition, this.buffer, 0);
                    if (this.bufferRemainingFrames != 0) break block4;
                    this.dataPosition += 4096;
                } while (this.dataPosition < this.data.length);
                throw new EOFException("Out of frames!");
            }
            this.dataPosition += this.res.getLastFrameBytes();
        }
    }
}

