/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio.fileio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOSource;
import gabien.media.midi.MIDISequence;
import gabien.media.midi.MIDISynthesizer;
import gabien.media.midi.MIDITimer;
import gabien.media.midi.MIDITracker;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class MIDISynthesizerSource
extends AudioIOSource.SourceF32 {
    private final MIDITracker tracker;
    private final MIDITimer timer;
    private final MIDISynthesizer synthesizer;
    private final int frameCount;
    private final int chunkSize;
    private int totalFramesConsumed;

    public MIDISynthesizerSource(@NonNull MIDISequence sequence, @NonNull MIDISynthesizer synth, double cooloff) {
        super(new AudioIOCRSet(2, synth.sampleRate));
        double totalTime = sequence.calcTimingInformation().lengthSeconds + cooloff;
        this.synthesizer = synth;
        this.tracker = new MIDITracker(sequence, this.synthesizer);
        this.timer = new MIDITimer(this.tracker);
        this.frameCount = (int)(totalTime * (double)synth.sampleRate);
        this.chunkSize = synth.sampleRate > 100 ? synth.sampleRate / 100 : 1;
        this.timer.resolve();
    }

    @Override
    public int frameCount() {
        return this.frameCount;
    }

    @Override
    public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
        while (frames > 0) {
            if (frames > this.chunkSize) {
                this.nextFramesChunk(frame, at, this.chunkSize);
                frames -= this.chunkSize;
                at += this.chunkSize * 2;
                continue;
            }
            this.nextFramesChunk(frame, at, frames);
            break;
        }
    }

    private void nextFramesChunk(float[] frame, int at, int frames) throws IOException {
        Arrays.fill(frame, at, at + frames * 2, 0.0f);
        this.synthesizer.render(frame, at, frames);
        this.synthesizer.update((double)frames / (double)this.synthesizer.sampleRate);
        this.totalFramesConsumed += frames;
        this.timer.currentTime = (double)this.totalFramesConsumed / (double)this.synthesizer.sampleRate;
        this.timer.resolve();
    }
}

