/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSource;
import gabien.media.audio.DiscreteSample;
import java.util.LinkedList;

public class StreamingAudioDiscreteSample
extends DiscreteSample {
    public final AudioIOSource baseSource;
    private final AudioIOFormat storageFormat;
    private final LinkedList<byte[]> chunks = new LinkedList();
    private final int frameSize;
    private final int chunkSize;
    private int framesCached;
    private int remainingFramesToCache;

    public StreamingAudioDiscreteSample(AudioIOSource source, AudioIOFormat fmt) {
        this(source, fmt, 4096);
    }

    public StreamingAudioDiscreteSample(AudioIOSource source, AudioIOFormat fmt, int cs) {
        super(source.crSet, source.frameCount());
        this.storageFormat = fmt;
        this.chunkSize = cs;
        this.frameSize = this.channels * fmt.bytesPerSample;
        this.baseSource = source;
        this.framesCached = 0;
        this.remainingFramesToCache = this.length;
    }

    private boolean addChunk() {
        int framesInThisChunk = this.chunkSize;
        if (this.remainingFramesToCache < framesInThisChunk) {
            framesInThisChunk = this.remainingFramesToCache;
        }
        if (framesInThisChunk <= 0) {
            return false;
        }
        byte[] chunkContent = new byte[framesInThisChunk * this.frameSize];
        try {
            this.baseSource.nextFramesInFormat(this.storageFormat, chunkContent, 0, framesInThisChunk);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chunks.add(chunkContent);
        this.remainingFramesToCache -= framesInThisChunk;
        this.framesCached += framesInThisChunk;
        return true;
    }

    private void locateFrame(int frame, Object buffer, boolean wantsF32) {
        while (frame >= this.framesCached) {
            if (this.addChunk()) continue;
            return;
        }
        int chunkIdx = frame / this.chunkSize;
        if (chunkIdx < 0 || chunkIdx >= this.chunks.size()) {
            return;
        }
        byte[] chk = this.chunks.get(chunkIdx);
        int chunkFrames = chk.length / this.frameSize;
        if ((frame -= chunkIdx * this.chunkSize) >= chunkFrames) {
            return;
        }
        int chkOfs = frame * this.frameSize;
        if (wantsF32) {
            float[] buf = (float[])buffer;
            for (int i = 0; i < this.channels; ++i) {
                buf[i] = (float)this.storageFormat.asF64(chk, chkOfs);
                chkOfs += this.storageFormat.bytesPerSample;
            }
        } else {
            int[] buf = (int[])buffer;
            for (int i = 0; i < this.channels; ++i) {
                buf[i] = this.storageFormat.asS32(chk, chkOfs);
                chkOfs += this.storageFormat.bytesPerSample;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getF32(int frame, float[] buffer) {
        StreamingAudioDiscreteSample streamingAudioDiscreteSample = this;
        synchronized (streamingAudioDiscreteSample) {
            this.locateFrame(frame, buffer, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getS32(int frame, int[] buffer) {
        StreamingAudioDiscreteSample streamingAudioDiscreteSample = this;
        synchronized (streamingAudioDiscreteSample) {
            this.locateFrame(frame, buffer, false);
        }
    }
}

