/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import gabien.uslx.append.MathsX;

public final class PCMConversions {
    private PCMConversions() {
    }

    public static void pcmS16ToS32(short[] source, int sourceOfs, int[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            int v = source[sourceOfs++] & 0xFFFF;
            dest[destOfs++] = v ^ 0x8000 | v << 16;
        }
    }

    public static void pcmS16ToS32(short[] source, int[] dest) {
        PCMConversions.pcmS16ToS32(source, 0, dest, 0, source.length);
    }

    public static void pcmS8ToS32(byte[] source, int sourceOfs, int[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            int v = source[sourceOfs++] & 0xFF;
            int vX = v ^ 0x80;
            dest[destOfs++] = vX | vX << 8 | vX << 16 | v << 24;
        }
    }

    public static void pcmS8ToS32(byte[] source, int[] dest) {
        PCMConversions.pcmS8ToS32(source, 0, dest, 0, source.length);
    }

    public static void pcmS8ToS16(byte[] source, int sourceOfs, short[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            int v = source[sourceOfs++] & 0xFF;
            int vX = v ^ 0x80;
            dest[destOfs++] = (short)(vX | vX << 8);
        }
    }

    public static void pcmS8ToS16(byte[] source, short[] dest) {
        PCMConversions.pcmS8ToS16(source, 0, dest, 0, source.length);
    }

    public static void pcmS32ToS16(int[] source, int sourceOfs, short[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            dest[destOfs++] = (short)(source[sourceOfs++] >> 16);
        }
    }

    public static void pcmS32ToS16(int[] source, short[] dest) {
        PCMConversions.pcmS32ToS16(source, 0, dest, 0, source.length);
    }

    public static void pcmS32ToS8(int[] source, int sourceOfs, byte[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            dest[destOfs++] = (byte)(source[sourceOfs++] >> 24);
        }
    }

    public static void pcmS32ToS8(int[] source, byte[] dest) {
        PCMConversions.pcmS32ToS8(source, 0, dest, 0, source.length);
    }

    public static void pcmS16ToS8(short[] source, int sourceOfs, byte[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            dest[destOfs++] = (byte)(source[sourceOfs++] >> 8);
        }
    }

    public static void pcmS16ToS8(short[] source, byte[] dest) {
        PCMConversions.pcmS16ToS8(source, 0, dest, 0, source.length);
    }

    public static void pcmF64ToS16(double[] source, int sourceOfs, short[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            double flt;
            flt *= (flt = source[sourceOfs++]) < 0.0 ? 32768.0 : 32767.0;
            flt = MathsX.clamp(flt, -32768.0, 32767.0);
            dest[destOfs++] = (short)flt;
        }
    }

    public static void pcmF64ToS16(double[] source, short[] dest) {
        PCMConversions.pcmF64ToS16(source, 0, dest, 0, source.length);
    }

    public static void pcmS16ToF64(short[] source, int sourceOfs, double[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            double flt;
            dest[destOfs++] = flt /= (flt = (double)source[sourceOfs++]) < 0.0 ? 32768.0 : 32767.0;
        }
    }

    public static void pcmS16ToF64(short[] source, double[] dest) {
        PCMConversions.pcmS16ToF64(source, 0, dest, 0, source.length);
    }

    public static void pcmF64ToS32(double[] source, int sourceOfs, int[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            double flt;
            flt *= (flt = source[sourceOfs++]) < 0.0 ? 2.147483648E9 : 2.147483647E9;
            flt = MathsX.clamp(flt, -2.147483648E9, 2.147483647E9);
            dest[destOfs++] = (int)flt;
        }
    }

    public static void pcmF64ToS32(double[] source, int[] dest) {
        PCMConversions.pcmF64ToS32(source, 0, dest, 0, source.length);
    }

    public static void pcmS32ToF64(int[] source, int sourceOfs, double[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            double flt;
            dest[destOfs++] = (int)(flt /= (flt = (double)source[sourceOfs++]) < 0.0 ? 2.147483648E9 : 2.147483647E9);
        }
    }

    public static void pcmS32ToF64(int[] source, double[] dest) {
        PCMConversions.pcmS32ToF64(source, 0, dest, 0, source.length);
    }

    public static void pcmF32ToS16(float[] source, int sourceOfs, short[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            float flt;
            flt *= (flt = source[sourceOfs++]) < 0.0f ? 32768.0f : 32767.0f;
            flt = MathsX.clamp(flt, -32768.0f, 32767.0f);
            dest[destOfs++] = (short)flt;
        }
    }

    public static void pcmF32ToS16(float[] source, short[] dest) {
        PCMConversions.pcmF32ToS16(source, 0, dest, 0, source.length);
    }

    public static void pcmS16ToF32(short[] source, int sourceOfs, float[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            float flt;
            dest[destOfs++] = flt /= (flt = (float)source[sourceOfs++]) < 0.0f ? 32768.0f : 32767.0f;
        }
    }

    public static void pcmS16ToF32(short[] source, float[] dest) {
        PCMConversions.pcmS16ToF32(source, 0, dest, 0, source.length);
    }

    public static void pcmF32ToS32(float[] source, int sourceOfs, int[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            float flt = source[sourceOfs++];
            flt = (float)((double)flt * (flt < 0.0f ? 2.147483648E9 : 2.147483647E9));
            flt = MathsX.clamp(flt, -2.1474836E9f, 2.1474836E9f);
            dest[destOfs++] = (short)flt;
        }
    }

    public static void pcmF32ToS32(float[] source, int[] dest) {
        PCMConversions.pcmF32ToS32(source, 0, dest, 0, source.length);
    }

    public static void pcmS32ToF32(int[] source, int sourceOfs, float[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            float flt = source[sourceOfs++];
            flt = (float)((double)flt / (flt < 0.0f ? 2.147483648E9 : 2.147483647E9));
            dest[destOfs++] = flt;
        }
    }

    public static void pcmS32ToF32(int[] source, float[] dest) {
        PCMConversions.pcmS32ToF32(source, 0, dest, 0, source.length);
    }

    public static void flipSign(byte[] source, int sourceOfs, byte[] dest, int destOfs, int sourceLen) {
        for (int i = 0; i < sourceLen; ++i) {
            dest[destOfs++] = (byte)(source[sourceOfs++] ^ 0x80);
        }
    }
}

