/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSample;
import gabien.uslx.append.MathsX;
import gabien.uslx.append.TemporaryResultsBuffer;

public abstract class DiscreteSample
extends AudioIOCRSet {
    private final TemporaryResultsBuffer.F32 tmpFloats;
    public final int length;

    public DiscreteSample(AudioIOCRSet crs, int l) {
        super(crs);
        this.tmpFloats = new TemporaryResultsBuffer.F32(this.channels);
        this.length = l;
    }

    public abstract void getS32(int var1, int[] var2);

    public abstract void getF32(int var1, float[] var2);

    private final void getExtendedF32(int frame, float[] buffer, boolean loop) {
        if (loop) {
            frame = this.length != 0 ? (frame %= this.length) : 0;
        } else if (frame < 0 || frame >= this.length) {
            for (int i = 0; i < this.channels; ++i) {
                buffer[i] = 0.0f;
            }
            return;
        }
        this.getF32(frame, buffer);
    }

    public final void getInterpolatedF32(double frame, float[] buffer, boolean loop) {
        if (loop) {
            frame = this.length != 0 ? (frame %= (double)this.length) : 0.0;
        }
        int frame1 = (int)Math.floor(frame);
        float frac = (float)(frame - (double)frame1);
        int frame2 = frame1 + 1;
        float[] tmpIB = (float[])this.tmpFloats.get();
        this.getExtendedF32(frame1, buffer, loop);
        this.getExtendedF32(frame2, tmpIB, loop);
        for (int i = 0; i < this.channels; ++i) {
            buffer[i] = MathsX.lerpUnclamped(buffer[i], tmpIB[i], frac);
        }
    }

    public final AudioIOSample resample(AudioIOCRSet set, boolean loop) {
        float[] tmp = new float[this.channels];
        float[] tmp2 = new float[set.channels];
        AudioIOSample res = new AudioIOSample(set, AudioIOFormat.F_F32, (int)((long)set.sampleRate * (long)this.length / (long)this.sampleRate));
        double cvt = (double)this.sampleRate / (double)set.sampleRate;
        if (set.channels != 0) {
            for (int i = 0; i < res.length; ++i) {
                this.getInterpolatedF32((double)i * cvt, tmp, loop);
                if (this.channels > 1) {
                    tmp2[0] = tmp[0];
                    if (tmp2.length > 1) {
                        tmp2[1] = tmp[1];
                    }
                } else if (this.channels > 0) {
                    tmp2[0] = tmp[0];
                    if (tmp2.length > 1) {
                        tmp2[1] = tmp[0];
                    }
                }
                res.setF32(i, tmp2);
            }
        }
        return res;
    }
}

