/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.PCMConversions;
import gabien.uslx.append.ArrayConversions;
import java.io.Closeable;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AudioIOSource
implements Closeable {
    @NonNull
    public final AudioIOCRSet crSet;
    @Nullable
    public final AudioIOFormat formatHint;

    public AudioIOSource(@NonNull AudioIOCRSet cr, @Nullable AudioIOFormat hint) {
        this.crSet = cr;
        this.formatHint = hint;
    }

    public abstract int frameCount();

    public abstract void nextFrames(@NonNull double[] var1, int var2, int var3) throws IOException;

    public abstract void nextFrames(@NonNull float[] var1, int var2, int var3) throws IOException;

    public abstract void nextFrames(@NonNull int[] var1, int var2, int var3) throws IOException;

    public void nextFramesInFormat(@NonNull AudioIOFormat fmt, @NonNull byte[] frame, int at, int frames) throws IOException {
        double[] tmp = new double[frames * this.crSet.channels];
        this.nextFrames(tmp, 0, frames);
        for (int i = 0; i < tmp.length; ++i) {
            fmt.ofF64(frame, at, tmp[i]);
            at += fmt.bytesPerSample;
        }
    }

    public final double[] readAllAsF64() throws IOException {
        int frames = this.frameCount();
        double[] res = new double[frames * this.crSet.channels];
        this.nextFrames(res, 0, frames);
        return res;
    }

    public final float[] readAllAsF32() throws IOException {
        int frames = this.frameCount();
        float[] res = new float[frames * this.crSet.channels];
        this.nextFrames(res, 0, frames);
        return res;
    }

    public final int[] readAllAsS32() throws IOException {
        int frames = this.frameCount();
        int[] res = new int[frames * this.crSet.channels];
        this.nextFrames(res, 0, frames);
        return res;
    }

    @Override
    public void close() throws IOException {
    }

    public static abstract class SourceF64
    extends AudioIOSource {
        private final double[] tmpBuf;

        public SourceF64(@NonNull AudioIOCRSet crSet) {
            super(crSet, AudioIOFormat.F_F64);
            this.tmpBuf = new double[crSet.channels];
        }

        @Override
        public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                ArrayConversions.castF64ToF32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }

        @Override
        public void nextFrames(@NonNull int[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmF64ToS32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }
    }

    public static abstract class SourceF32
    extends AudioIOSource {
        private final float[] tmpBuf;

        public SourceF32(@NonNull AudioIOCRSet crSet) {
            super(crSet, AudioIOFormat.F_F32);
            this.tmpBuf = new float[crSet.channels];
        }

        @Override
        public void nextFrames(@NonNull double[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                ArrayConversions.castF32ToF64(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }

        @Override
        public void nextFrames(@NonNull int[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmF32ToS32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }
    }

    public static abstract class SourceS32
    extends AudioIOSource {
        private final int[] tmpBuf;

        public SourceS32(@NonNull AudioIOCRSet crSet) {
            super(crSet, AudioIOFormat.F_S32);
            this.tmpBuf = new int[crSet.channels];
        }

        @Override
        public void nextFrames(@NonNull double[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmS32ToF64(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }

        @Override
        public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmS32ToF32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }
    }

    public static abstract class SourceS16
    extends AudioIOSource {
        private final short[] tmpBuf;

        public SourceS16(@NonNull AudioIOCRSet crSet) {
            super(crSet, AudioIOFormat.F_S16);
            this.tmpBuf = new short[crSet.channels];
        }

        public abstract void nextFrames(short[] var1, int var2, int var3);

        @Override
        public void nextFrames(@NonNull double[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmS16ToF64(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }

        @Override
        public void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmS16ToF32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }

        @Override
        public void nextFrames(@NonNull int[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                PCMConversions.pcmS16ToS32(this.tmpBuf, 0, frame, at, this.crSet.channels);
                at += this.crSet.channels;
            }
        }
    }

    public static abstract class SourceBytes
    extends AudioIOSource {
        private final byte[] tmpBuf;
        public final AudioIOFormat format;

        public SourceBytes(@NonNull AudioIOCRSet crSet, @NonNull AudioIOFormat format) {
            super(crSet, format);
            this.tmpBuf = new byte[crSet.channels * format.bytesPerSample];
            this.format = format;
        }

        public abstract void nextFrames(@NonNull byte[] var1, int var2, int var3) throws IOException;

        @Override
        public final void nextFrames(@NonNull double[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                for (int j = 0; j < this.crSet.channels; ++j) {
                    frame[at++] = this.format.asF64(this.tmpBuf, j * this.format.bytesPerSample);
                }
            }
        }

        @Override
        public final void nextFrames(@NonNull float[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                for (int j = 0; j < this.crSet.channels; ++j) {
                    frame[at++] = (float)this.format.asF64(this.tmpBuf, j * this.format.bytesPerSample);
                }
            }
        }

        @Override
        public final void nextFrames(@NonNull int[] frame, int at, int frames) throws IOException {
            for (int i = 0; i < frames; ++i) {
                this.nextFrames(this.tmpBuf, 0, 1);
                for (int j = 0; j < this.crSet.channels; ++j) {
                    frame[at++] = this.format.asS32(this.tmpBuf, j * this.format.bytesPerSample);
                }
            }
        }

        @Override
        public void nextFramesInFormat(@NonNull AudioIOFormat fmt, @NonNull byte[] frame, int at, int frames) throws IOException {
            if (fmt == this.format) {
                this.nextFrames(frame, at, frames);
            } else {
                super.nextFramesInFormat(fmt, frame, at, frames);
            }
        }
    }
}

