/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import gabien.media.audio.AudioIOCRSet;
import gabien.media.audio.AudioIOFormat;
import gabien.media.audio.AudioIOSource;
import gabien.media.audio.DiscreteSample;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class AudioIOSample
extends DiscreteSample {
    public final AudioIOFormat format;
    public final byte[] data;
    public final int bytesPerFrame;

    public AudioIOSample(AudioIOSource src, AudioIOFormat fmt) throws IOException {
        this(src.crSet, fmt, src.frameCount());
        src.nextFramesInFormat(fmt, this.data, 0, this.data.length / this.bytesPerFrame);
    }

    public AudioIOSample(AudioIOCRSet crs, AudioIOFormat fmt, int len) {
        super(crs, len);
        this.format = fmt;
        this.bytesPerFrame = crs.channels * fmt.bytesPerSample;
        this.data = new byte[this.length * this.bytesPerFrame];
    }

    public AudioIOSource getSource() {
        return new AudioIOSource.SourceBytes(this, this.format){
            int ptr;
            {
                this.ptr = 0;
            }

            @Override
            public void nextFrames(@NonNull byte[] frame, int at, int frames) throws IOException {
                System.arraycopy(AudioIOSample.this.data, this.ptr, frame, at, AudioIOSample.this.bytesPerFrame);
                this.ptr += AudioIOSample.this.bytesPerFrame;
            }

            @Override
            public int frameCount() {
                return AudioIOSample.this.length;
            }
        };
    }

    @Override
    public final void getF32(int frame, float[] buffer) {
        int at = frame * this.bytesPerFrame;
        for (int i = 0; i < this.channels; ++i) {
            buffer[i] = (float)this.format.asF64(this.data, at);
            at += this.format.bytesPerSample;
        }
    }

    @Override
    public final void getS32(int frame, int[] buffer) {
        int at = frame * this.bytesPerFrame;
        for (int i = 0; i < this.channels; ++i) {
            buffer[i] = this.format.asS32(this.data, at);
            at += this.format.bytesPerSample;
        }
    }

    public final void setF32(int frame, float[] buffer) {
        int at = frame * this.bytesPerFrame;
        for (int i = 0; i < this.channels; ++i) {
            this.format.ofF64(this.data, at, buffer[i]);
            at += this.format.bytesPerSample;
        }
    }

    public final void setS32(int frame, int[] buffer) {
        int at = frame * this.bytesPerFrame;
        for (int i = 0; i < this.channels; ++i) {
            this.format.ofS32(this.data, at, buffer[i]);
            at += this.format.bytesPerSample;
        }
    }
}

