/*
 * Decompiled with CFR 0.152.
 */
package gabien.media.audio;

import org.eclipse.jdt.annotation.NonNull;

public abstract class AudioIOFormat {
    public static final int FC_PCM = 1;
    public static final int FC_FLOAT = 3;
    public static final int FC_ALAW = 6;
    public static final int FC_ULAW = 7;
    public static final int REQ_FACT = 1;
    public static final int REQ_EXT_SIZE = 2;
    public static final int REQ_EXT_MODE = 4;
    public static final AudioIOFormat F_U8 = new PCM(false, 0, 8, 1);
    public static final AudioIOFormat F_AL8 = new NoConv(6, 1, 8, 1);
    public static final AudioIOFormat F_UL8 = new NoConv(7, 1, 8, 1);
    public static final AudioIOFormat F_S16 = new PCM(true, 0, 16, 2);
    public static final AudioIOFormat F_S24 = new PCM(true, 7, 24, 3);
    public static final AudioIOFormat F_S32 = new PCM(true, 0, 32, 4);
    public static final AudioIOFormat F_F32 = new FP(false);
    public static final AudioIOFormat F_F64 = new FP(true);
    public final int formatCode;
    public final int requirements;
    public final int bitsPerSample;
    public final int bytesPerSample;

    private AudioIOFormat(int fmt, int req, int bitsPS, int bytesPS) {
        this.formatCode = fmt;
        this.requirements = req;
        this.bitsPerSample = bitsPS;
        this.bytesPerSample = bytesPS;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " FC=" + this.formatCode + " bitsPerSample=" + this.bitsPerSample;
    }

    public static AudioIOFormat detect(int fmt, int sampleBits) {
        if (fmt == 1) {
            if (sampleBits == 8) {
                return F_U8;
            }
            if (sampleBits == 16) {
                return F_S16;
            }
            if (sampleBits == 24) {
                return F_S24;
            }
            if (sampleBits == 32) {
                return F_S32;
            }
        } else {
            if (fmt == 3) {
                return sampleBits == 64 ? F_F64 : F_F32;
            }
            if (fmt == 7) {
                return F_UL8;
            }
            if (fmt == 6) {
                return F_AL8;
            }
        }
        throw new UnsupportedOperationException("Unable to comprehend WAV format code " + fmt + ".");
    }

    public abstract int asS32(@NonNull byte[] var1, int var2);

    public abstract double asF64(@NonNull byte[] var1, int var2);

    public abstract void ofS32(@NonNull byte[] var1, int var2, int var3);

    public abstract void ofF64(@NonNull byte[] var1, int var2, double var3);

    public static double cS32toF64(int valI) {
        double val = valI;
        if (val < 0.0) {
            return val / 2.147483648E9;
        }
        return val / 2.147483647E9;
    }

    public static int cF64toS32(double val) {
        if (val < 0.0) {
            if (val < -1.0) {
                val = -1.0;
            }
            val *= 2.147483648E9;
        } else {
            if (val > 1.0) {
                val = 1.0;
            }
            val *= 2.147483647E9;
        }
        return (int)val;
    }

    public static class FP
    extends AudioIOFormat {
        public final boolean dbl;

        public FP(boolean d) {
            super(3, 1, d ? 64 : 32, d ? 8 : 4);
            this.dbl = d;
        }

        @Override
        public int asS32(@NonNull byte[] from, int at) {
            return FP.cF64toS32(this.asF64(from, at));
        }

        @Override
        public double asF64(@NonNull byte[] from, int at) {
            if (this.dbl) {
                long val = (long)from[at] & 0xFFL;
                val |= ((long)from[at + 1] & 0xFFL) << 8;
                val |= ((long)from[at + 2] & 0xFFL) << 16;
                val |= ((long)from[at + 3] & 0xFFL) << 24;
                val |= ((long)from[at + 4] & 0xFFL) << 32;
                val |= ((long)from[at + 5] & 0xFFL) << 40;
                val |= ((long)from[at + 6] & 0xFFL) << 48;
                return Double.longBitsToDouble(val |= ((long)from[at + 7] & 0xFFL) << 56);
            }
            int val = from[at] & 0xFF;
            val |= (from[at + 1] & 0xFF) << 8;
            val |= (from[at + 2] & 0xFF) << 16;
            return Float.intBitsToFloat(val |= (from[at + 3] & 0xFF) << 24);
        }

        @Override
        public void ofS32(@NonNull byte[] to, int at, int val) {
            this.ofF64(to, at, FP.cS32toF64(val));
        }

        @Override
        public void ofF64(@NonNull byte[] to, int at, double val) {
            if (this.dbl) {
                long val2 = Double.doubleToRawLongBits(val);
                to[at] = (byte)val2;
                to[at + 1] = (byte)(val2 >> 8);
                to[at + 2] = (byte)(val2 >> 16);
                to[at + 3] = (byte)(val2 >> 24);
                to[at + 4] = (byte)(val2 >> 32);
                to[at + 5] = (byte)(val2 >> 40);
                to[at + 6] = (byte)(val2 >> 48);
                to[at + 7] = (byte)(val2 >> 56);
            } else {
                int val2 = Float.floatToRawIntBits((float)val);
                to[at] = (byte)val2;
                to[at + 1] = (byte)(val2 >> 8);
                to[at + 2] = (byte)(val2 >> 16);
                to[at + 3] = (byte)(val2 >> 24);
            }
        }
    }

    public static class PCM
    extends AudioIOFormat {
        public final boolean signed;

        public PCM(boolean s, int req, int bitsPS, int bytesPS) {
            super(1, req, bitsPS, bytesPS);
            this.signed = s;
        }

        @Override
        public int asS32(@NonNull byte[] from, int at) {
            int val;
            if (this.bytesPerSample == 1) {
                val = from[at] & 0xFF;
                val |= val << 8;
                val |= val << 16;
                val ^= this.signed ? 0x808080 : Integer.MIN_VALUE;
            } else if (this.bytesPerSample == 2) {
                val = from[at] & 0xFF;
                val |= (from[at + 1] & 0xFF) << 8;
                val |= val << 16;
                val ^= this.signed ? 32768 : Integer.MIN_VALUE;
            } else if (this.bytesPerSample == 3) {
                val = from[at] & 0xFF;
                val |= (from[at + 1] & 0xFF) << 8;
                int hb = from[at + 2] & 0xFF;
                val |= hb << 24;
                val |= hb;
                val ^= this.signed ? 128 : Integer.MIN_VALUE;
            } else if (this.bytesPerSample == 4) {
                val = from[at] & 0xFF;
                val |= (from[at + 1] & 0xFF) << 8;
                val |= (from[at + 2] & 0xFF) << 16;
                val |= (from[at + 3] & 0xFF) << 24;
                val ^= this.signed ? 0 : Integer.MIN_VALUE;
            } else {
                throw new UnsupportedOperationException("Can't convert this width");
            }
            return val;
        }

        @Override
        public double asF64(@NonNull byte[] from, int at) {
            return PCM.cS32toF64(this.asS32(from, at));
        }

        @Override
        public void ofS32(@NonNull byte[] to, int at, int val) {
            if (!this.signed) {
                val ^= Integer.MIN_VALUE;
            }
            if (this.bytesPerSample == 1) {
                to[at] = (byte)(val >> 24);
            } else if (this.bytesPerSample == 2) {
                to[at] = (byte)(val >> 16);
                to[at + 1] = (byte)(val >> 24);
            } else if (this.bytesPerSample == 3) {
                to[at] = (byte)(val >> 8);
                to[at + 1] = (byte)(val >> 16);
                to[at + 2] = (byte)(val >> 24);
            } else if (this.bytesPerSample == 4) {
                to[at] = (byte)val;
                to[at + 1] = (byte)(val >> 8);
                to[at + 2] = (byte)(val >> 16);
                to[at + 3] = (byte)(val >> 24);
            } else {
                throw new UnsupportedOperationException("Can't convert this width");
            }
        }

        @Override
        public void ofF64(@NonNull byte[] to, int at, double val) {
            this.ofS32(to, at, PCM.cF64toS32(val));
        }
    }

    public static class NoConv
    extends AudioIOFormat {
        public NoConv(int fmt, int req, int bitsPS, int bytesPS) {
            super(fmt, req, bitsPS, bytesPS);
        }

        @Override
        public int asS32(@NonNull byte[] from, int at) {
            throw new UnsupportedOperationException("Can't convert this format");
        }

        @Override
        public double asF64(@NonNull byte[] from, int at) {
            throw new UnsupportedOperationException("Can't convert this format");
        }

        @Override
        public void ofS32(@NonNull byte[] to, int at, int val) {
            throw new UnsupportedOperationException("Can't convert this format");
        }

        @Override
        public void ofF64(@NonNull byte[] to, int at, double val) {
            throw new UnsupportedOperationException("Can't convert this format");
        }
    }
}

