/*
 * Decompiled with CFR 0.152.
 */
package gabien.media;

import gabien.uslx.io.LEDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class ChunkedInputStream
extends LEDataInputStream {
    public final int chunkLen;
    protected int chunkPos;
    protected int resetPos;
    protected boolean holdoffLimiters = true;

    public ChunkedInputStream(@NonNull InputStream in, @Nullable Object indicator) throws IOException {
        super(in);
        this.chunkLen = this.readChunkHeader(indicator);
        this.holdoffLimiters = false;
    }

    protected abstract int readChunkHeader(Object var1) throws IOException;

    public final int remainingInChunk() {
        return this.chunkLen - this.chunkPos;
    }

    @Override
    public void close() throws IOException {
        this.skipBytes(this.chunkLen - this.chunkPos);
    }

    @Override
    public int read() throws IOException {
        if (this.holdoffLimiters) {
            return super.read();
        }
        if (this.chunkPos >= this.chunkLen) {
            return -1;
        }
        int res = super.read();
        if (res != -1) {
            ++this.chunkPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res;
        if (this.holdoffLimiters) {
            return super.read(b, off, len);
        }
        int efAvailable = this.chunkLen - this.chunkPos;
        if (efAvailable < len) {
            len = efAvailable;
        }
        if ((res = super.read(b, off, len)) > 0) {
            this.chunkPos += res;
        }
        return res;
    }

    @Override
    public int available() throws IOException {
        int efAvailable;
        if (this.holdoffLimiters) {
            return super.available();
        }
        int actualAvailable = super.available();
        if (actualAvailable > (efAvailable = this.chunkLen - this.chunkPos)) {
            return efAvailable;
        }
        return actualAvailable;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.holdoffLimiters) {
            return super.skip(n);
        }
        int efAvailable = this.chunkLen - this.chunkPos;
        if (n > (long)efAvailable) {
            n = efAvailable;
        }
        long res = super.skip(n);
        this.chunkPos += (int)res;
        return res;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.chunkPos = this.resetPos;
        super.reset();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.resetPos = this.chunkPos;
        super.mark(readlimit);
    }
}

