/*
 * Decompiled with CFR 0.152.
 */
package gabien.datum;

import datum.DatumInvalidVisitor;
import datum.DatumPositionedException;
import datum.DatumProxyVisitor;
import datum.DatumSrcLoc;
import datum.DatumVisitor;
import java.util.Map;

public abstract class DatumODecVisitor<T>
extends DatumInvalidVisitor {
    public Map<String, Handler<T>> handlers;
    public T context;

    public DatumODecVisitor(Map<String, Handler<T>> handlers, T context) {
        this.handlers = handlers;
        this.context = context;
    }

    @Override
    public final DatumVisitor visitList(DatumSrcLoc srcLoc) {
        return new DatumProxyVisitor(DatumInvalidVisitor.INSTANCE){
            boolean done;
            {
                this.done = false;
            }

            @Override
            public void visitId(String s, DatumSrcLoc srcLoc) {
                if (this.done) {
                    super.visitId(s, srcLoc);
                } else {
                    Handler h = DatumODecVisitor.this.handlers.get(s);
                    if (h == null) {
                        throw new DatumPositionedException(srcLoc, "No handler for: " + s);
                    }
                    this.target = h.handle(s, DatumODecVisitor.this, DatumODecVisitor.this.context);
                    this.done = true;
                }
            }

            @Override
            public void onVisitedValue() {
            }
        };
    }

    public static interface Handler<T> {
        public DatumVisitor handle(String var1, DatumODecVisitor<T> var2, T var3);
    }
}

