/*
 * Decompiled with CFR 0.152.
 */
package gabien.datum;

import datum.DatumInvalidVisitor;
import datum.DatumPositionedException;
import datum.DatumProxyVisitor;
import datum.DatumSrcLoc;
import datum.DatumStreamingVisitor;
import datum.DatumSymbol;
import datum.DatumVisitor;
import java.util.Map;

public class DatumODec1Visitor<HT, RT>
extends DatumStreamingVisitor {
    public Map<String, Handler<HT>> handlers;
    public HT context;
    public Returner<RT> returner;
    public RT returnerContext;

    public DatumODec1Visitor(Map<String, Handler<HT>> handlers, HT context, Returner<RT> returner, RT returnerContext) {
        this.handlers = handlers;
        this.context = context;
        this.returner = returner;
        this.returnerContext = returnerContext;
    }

    public void returnVal(Object v, DatumSrcLoc srcLoc) {
        this.returner.accept(v, this.returnerContext, srcLoc);
    }

    @Override
    public final void visitString(String s, DatumSrcLoc srcLoc) {
        this.returner.accept(s, this.returnerContext, srcLoc);
    }

    @Override
    public final void visitId(String s, DatumSrcLoc srcLoc) {
        this.returner.accept(new DatumSymbol(s), this.returnerContext, srcLoc);
    }

    @Override
    public final void visitBoolean(boolean value, DatumSrcLoc srcLoc) {
        this.returner.accept(value, this.returnerContext, srcLoc);
    }

    @Override
    public final void visitNull(DatumSrcLoc srcLoc) {
        this.returner.accept(null, this.returnerContext, srcLoc);
    }

    @Override
    public final void visitInt(long value, DatumSrcLoc srcLoc) {
        this.returner.accept(value, this.returnerContext, srcLoc);
    }

    @Override
    public final void visitFloat(double value, DatumSrcLoc srcLoc) {
        this.returner.accept(value, this.returnerContext, srcLoc);
    }

    @Override
    public final DatumVisitor visitList(DatumSrcLoc srcLoc) {
        return new DatumProxyVisitor(DatumInvalidVisitor.INSTANCE){
            boolean done;
            {
                this.done = false;
            }

            @Override
            public void visitId(String s, DatumSrcLoc srcLoc) {
                if (this.done) {
                    super.visitId(s, srcLoc);
                } else {
                    Handler h = DatumODec1Visitor.this.handlers.get(s);
                    if (h == null) {
                        throw new DatumPositionedException(srcLoc, "No handler for: " + s);
                    }
                    this.target = h.handle(s, DatumODec1Visitor.this, DatumODec1Visitor.this.context);
                    this.done = true;
                }
            }

            @Override
            public void onVisitedValue() {
            }
        };
    }

    @Override
    public void visitEnd(DatumSrcLoc srcLoc) {
    }

    public static interface Returner<T> {
        public void accept(Object var1, T var2, DatumSrcLoc var3);
    }

    public static interface Handler<HT> {
        public DatumVisitor handle(String var1, DatumODec1Visitor<HT, ?> var2, HT var3);
    }
}

