/*
 * Decompiled with CFR 0.152.
 */
package gabien.datum;

import datum.DatumInvalidVisitor;
import datum.DatumPositionedException;
import datum.DatumProxyVisitor;
import datum.DatumSrcLoc;
import datum.DatumVisitor;

public abstract class DatumKVDVisitor
extends DatumProxyVisitor {
    protected boolean readingKey = true;

    public DatumKVDVisitor() {
        super(DatumInvalidVisitor.INSTANCE);
    }

    @Override
    public void onVisitedValue() {
        this.target = DatumInvalidVisitor.INSTANCE;
        this.readingKey = true;
    }

    @Override
    public void visitId(String s, DatumSrcLoc srcLoc) {
        if (!this.readingKey) {
            super.visitId(s, srcLoc);
            return;
        }
        this.target = this.handle(s, srcLoc);
        this.readingKey = false;
    }

    public abstract DatumVisitor handle(String var1, DatumSrcLoc var2);

    @Override
    public void visitEnd(DatumSrcLoc loc) {
        if (!this.readingKey) {
            throw new DatumPositionedException(loc, "Can't visit end in the middle of reading a value @ " + loc);
        }
    }
}

