/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.backend.DeadDesktopPeripherals;
import gabien.backend.IGaBIEn;
import gabien.backend.IGaBIEnMultiWindow;
import gabien.backend.ProxyDesktopPeripherals;
import gabien.backend.ProxyPeripherals;
import gabien.render.IImage;
import gabien.wsi.IDesktopPeripherals;
import gabien.wsi.IGrInDriver;
import gabien.wsi.IPeripherals;
import gabien.wsi.WindowSpecs;
import java.util.LinkedList;

public class WindowMux
implements IGaBIEnMultiWindow {
    public IGrInDriver underlyingWindow;
    public LinkedList<Window> windows = new LinkedList();
    public LinkedList<Window> windowsSystem = new LinkedList();
    private final IGaBIEn backend;

    public WindowMux(IGaBIEn backend, IGrInDriver underlying) {
        this.backend = backend;
        GaBIEn.verify(backend);
        this.underlyingWindow = underlying;
    }

    public Window getCurrentWindow() {
        if (!this.windowsSystem.isEmpty()) {
            return this.windowsSystem.getLast();
        }
        if (!this.windows.isEmpty()) {
            return this.windows.getLast();
        }
        return null;
    }

    @Override
    public boolean isActuallySingleWindow() {
        return true;
    }

    @Override
    public WindowSpecs defaultWindowSpecs(String name, int w, int h) {
        return new WindowSpecs(this.backend);
    }

    @Override
    public IGrInDriver makeGrIn(String name, int w, int h, WindowSpecs windowspecs) {
        Window wnd = new Window(this.underlyingWindow.getWidth(), this.underlyingWindow.getHeight());
        Window oldWnd = this.getCurrentWindow();
        if (windowspecs.engineIsOfSystemPriority(this.backend)) {
            this.windowsSystem.add(wnd);
        } else {
            this.windows.add(wnd);
        }
        this.performWindowTransition(oldWnd);
        return wnd;
    }

    private void performWindowTransition(Window o) {
        Window n = this.getCurrentWindow();
        if (o == n) {
            return;
        }
        this.underlyingWindow.getPeripherals().clearKeys();
        if (o != null) {
            o.windowPeripherals.target = DeadDesktopPeripherals.INSTANCE;
        }
        if (n != null) {
            n.windowPeripherals.target = this.underlyingWindow.getPeripherals();
        }
    }

    public class Window
    implements IGrInDriver {
        public boolean running = true;
        public final ProxyPeripherals<IPeripherals> windowPeripherals;

        public Window(int w, int h) {
            if (WindowMux.this.underlyingWindow.getPeripherals() instanceof IDesktopPeripherals) {
                ProxyDesktopPeripherals<IPeripherals> wp = new ProxyDesktopPeripherals<IPeripherals>();
                wp.target = DeadDesktopPeripherals.INSTANCE;
                this.windowPeripherals = wp;
            } else {
                this.windowPeripherals = new ProxyPeripherals();
                this.windowPeripherals.target = DeadDesktopPeripherals.INSTANCE;
            }
        }

        @Override
        public boolean stillRunning() {
            return this.running && WindowMux.this.underlyingWindow.stillRunning();
        }

        @Override
        public int getWidth() {
            return WindowMux.this.underlyingWindow.getWidth();
        }

        @Override
        public int getHeight() {
            return WindowMux.this.underlyingWindow.getHeight();
        }

        @Override
        public void flush(IImage backBuffer) {
            if (WindowMux.this.getCurrentWindow() == this) {
                WindowMux.this.underlyingWindow.flush(backBuffer);
            }
        }

        @Override
        public IPeripherals getPeripherals() {
            return this.windowPeripherals;
        }

        @Override
        public void shutdown() {
            if (this.running) {
                this.running = false;
                Window old = WindowMux.this.getCurrentWindow();
                WindowMux.this.windows.remove(this);
                WindowMux.this.windowsSystem.remove(this);
                WindowMux.this.performWindowTransition(old);
            }
        }

        @Override
        public int estimateUIScaleTenths() {
            return WindowMux.this.underlyingWindow.estimateUIScaleTenths();
        }
    }
}

