/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.uslx.append.TimeLogger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;

public abstract class WSIDownloadPair<T> {
    @Nullable
    private final TimeLogger.Source timeLoggerAcquire;
    @Nullable
    private final TimeLogger.Source[] timeLoggerHeld;
    @Nullable
    private final Object[] canon;
    private final ArrayBlockingQueue<T> queue;

    public WSIDownloadPair(String n, int capacity) {
        try {
            this.queue = new ArrayBlockingQueue(capacity);
            this.timeLoggerAcquire = TimeLogger.optSource(GaBIEn.timeLogger, n + ".ACQ");
            if (GaBIEn.timeLogger != null) {
                this.timeLoggerHeld = new TimeLogger.Source[capacity];
                this.canon = new Object[capacity];
                for (int i = 0; i < capacity; ++i) {
                    this.timeLoggerHeld[i] = TimeLogger.optSource(GaBIEn.timeLogger, n + "." + i + ".HLD");
                    T gen = this.genBuffer(0, 0);
                    this.canon[i] = gen;
                    this.queue.put(gen);
                }
            } else {
                this.timeLoggerHeld = null;
                this.canon = null;
                for (int i = 0; i < capacity; ++i) {
                    this.queue.put(this.genBuffer(1, 1));
                }
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    private int indexOf(T res) {
        int foundIndex = -1;
        for (int i = 0; i < this.canon.length; ++i) {
            if (this.canon[i] != res) continue;
            foundIndex = i;
            break;
        }
        if (foundIndex == -1) {
            throw new RuntimeException("Contaminant in queue not supposed to be there");
        }
        return foundIndex;
    }

    private T takeWithCrashRecovery() throws InterruptedException {
        do {
            T res;
            if ((res = this.queue.poll(5L, TimeUnit.SECONDS)) == null) continue;
            return res;
        } while (GaBIEn.vopeks.vopeksThread.isAlive());
        throw new RuntimeException("VOPEKS thread is dead. CHECK CONSOLE OUTPUT!");
    }

    public final T acquire(int width, int height) {
        try {
            T res;
            if (this.timeLoggerAcquire != null) {
                try (TimeLogger.Source src = TimeLogger.open(this.timeLoggerAcquire);){
                    res = this.takeWithCrashRecovery();
                }
                int foundIndex = this.indexOf(res);
                TimeLogger.open(this.timeLoggerHeld[foundIndex]);
                if (!this.bufferMatchesSize(res, width, height)) {
                    res = this.genBuffer(width, height);
                    this.canon[foundIndex] = res;
                }
            } else {
                res = this.takeWithCrashRecovery();
                if (!this.bufferMatchesSize(res, width, height)) {
                    res = this.genBuffer(width, height);
                }
            }
            return res;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public final void release(T buffer) {
        try {
            if (this.timeLoggerHeld != null) {
                int foundIndex = this.indexOf(buffer);
                TimeLogger.close(this.timeLoggerHeld[foundIndex]);
            }
            this.queue.put(buffer);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public abstract boolean bufferMatchesSize(T var1, int var2, int var3);

    public abstract T genBuffer(int var1, int var2);
}

