/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.ui.UIDynamicProxy;
import gabien.ui.UIElement;
import gabien.ui.elements.UILabel;
import gabien.ui.elements.UITextBox;
import gabien.ui.elements.UITextButton;
import gabien.ui.layouts.UIScrollLayout;
import gabien.ui.layouts.UISplitterLayout;
import gabien.uslx.append.Rect;
import java.util.Collections;
import java.util.LinkedList;
import java.util.function.Consumer;

public class UIFileBrowser
extends UIElement.UIProxy {
    private boolean done;
    private Consumer<String> run;
    private UILabel upperSection;
    private UIScrollLayout basicLayout;
    private UISplitterLayout outerLayout;
    private UIDynamicProxy lowerSection;
    private int fontSize;
    private LinkedList<String> pathComponents;
    private boolean saving;
    private String strTP;
    private String defaultFileName;

    public UIFileBrowser(String actPath, Consumer<String> r, String titlePrefix, boolean saving, int fSize, int scrollerSize, String dfn) {
        this.saving = saving;
        this.defaultFileName = dfn;
        this.run = r;
        this.strTP = titlePrefix;
        this.pathComponents = UIFileBrowser.createComponents(actPath);
        this.basicLayout = new UIScrollLayout(true, scrollerSize);
        this.upperSection = new UILabel("!", fSize);
        this.lowerSection = new UIDynamicProxy();
        this.fontSize = fSize;
        this.outerLayout = new UISplitterLayout(this.upperSection, new UISplitterLayout(this.basicLayout, this.lowerSection, true, 1.0), true, 0.0);
        this.rebuild();
        this.outerLayout.setForcedBounds(null, new Rect(this.outerLayout.getWantedSize()));
        this.proxySetElement(this.outerLayout, true);
    }

    public static LinkedList<String> createComponents(String browserDirectory) {
        LinkedList<String> lls = new LinkedList<String>();
        try {
            String[] old;
            browserDirectory = browserDirectory.replace('\\', '/');
            for (String s : old = browserDirectory.split("/")) {
                if (s.equals("") || s.equals(".")) continue;
                lls.add(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lls;
    }

    protected boolean shouldShow(boolean dir, String name) {
        return true;
    }

    private String getPath() {
        StringBuilder text = new StringBuilder("/");
        boolean first = true;
        for (String s : this.pathComponents) {
            if (!first) {
                text.append('/');
            }
            first = false;
            text.append(s);
        }
        return text.toString();
    }

    private void rebuild() {
        LinkedList<UITextButton> elms = new LinkedList<UITextButton>();
        this.basicLayout.panelsSet();
        this.lowerSection.dynProxySet(null);
        boolean showManualControl = true;
        String verb = this.saving ? GaBIEn.wordSave : GaBIEn.wordLoad;
        final String exact = this.getPath();
        this.upperSection.setText(exact);
        String[] paths = GaBIEn.listEntries(exact);
        elms.add(new UITextButton("<-", this.fontSize, () -> {
            if (!this.done) {
                if (this.pathComponents.size() == 0) {
                    this.done = true;
                    this.run.accept(null);
                    return;
                }
                this.pathComponents.removeLast();
                this.rebuild();
            }
        }));
        if (paths != null) {
            LinkedList<String> dirs = new LinkedList<String>();
            LinkedList<String> fils = new LinkedList<String>();
            for (String s : paths) {
                if (s.contains("\\")) {
                    throw new RuntimeException("Backend Error (\\)");
                }
                if (s.contains("/")) {
                    throw new RuntimeException("Backend Error (/)");
                }
                if (GaBIEn.dirExists(exact + "/" + s)) {
                    dirs.add(s);
                    continue;
                }
                fils.add(s);
            }
            Collections.sort(dirs);
            Collections.sort(fils);
            for (final String s : dirs) {
                if (!this.shouldShow(true, s)) continue;
                elms.add(new UITextButton("D: " + s, this.fontSize, new Runnable(){

                    @Override
                    public void run() {
                        UIFileBrowser.this.pathComponents.add(s);
                        UIFileBrowser.this.rebuild();
                    }
                }));
            }
            for (final String s : fils) {
                if (!this.shouldShow(false, s)) continue;
                elms.add(new UITextButton("F: " + s, this.fontSize, new Runnable(){

                    @Override
                    public void run() {
                        UIFileBrowser.this.pathComponents.add(s);
                        UIFileBrowser.this.rebuild();
                    }
                }));
            }
        } else if (!GaBIEn.dirExists(exact)) {
            showManualControl = false;
            elms.add(new UITextButton(verb + " " + exact, this.fontSize, new Runnable(){

                @Override
                public void run() {
                    if (!UIFileBrowser.this.done) {
                        UIFileBrowser.this.done = true;
                        UIFileBrowser.this.run.accept(exact);
                    }
                }
            }));
        }
        if (showManualControl) {
            UITextBox pathText = new UITextBox(this.defaultFileName, this.fontSize);
            UILabel statusLine = new UILabel("", this.fontSize);
            UISplitterLayout mainLine = new UISplitterLayout(pathText, new UITextButton(verb, this.fontSize, () -> {
                String txt = pathText.getText();
                if (txt.equals(".") || txt.equals("..") || txt.contains("/") || txt.contains("\\") || txt.equals("")) {
                    statusLine.setText(GaBIEn.wordInvalidFileName);
                    return;
                }
                statusLine.setText("");
                if (!this.done) {
                    this.done = true;
                    this.run.accept(exact + "/" + txt);
                }
            }), false, 1.0);
            this.lowerSection.dynProxySet(new UISplitterLayout(mainLine, statusLine, true, 0.5));
        }
        this.basicLayout.panelsSet(elms);
    }

    @Override
    public boolean requestsUnparenting() {
        return this.done;
    }

    @Override
    public void onWindowClose() {
        if (!this.done) {
            this.done = true;
            this.run.accept(null);
        }
    }

    @Override
    public String toString() {
        return this.strTP + this.getPath();
    }
}

