/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.text.IFixedSizeFont;
import gabien.text.ITypeface;
import org.eclipse.jdt.annotation.NonNull;

public final class NativeFontCache {
    private ITypeface defaultTypeface;
    private String lastTypefaceName = null;
    private ITypeface lastTypeface = null;
    private String lastFontName = null;
    private int lastFontSize = -1;
    private int lastFontStyle = -1;
    private IFixedSizeFont lastFont = null;
    private int lastDefaultFontSize = -1;
    private int lastDefaultFontStyle = -1;
    private IFixedSizeFont lastDefaultFont = null;
    private final IGaBIEn backend;

    public NativeFontCache(IGaBIEn backend) {
        this.backend = backend;
        GaBIEn.verify(backend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITypeface getTypeface(@NonNull String name) {
        NativeFontCache nativeFontCache = this;
        synchronized (nativeFontCache) {
            if (this.lastTypeface != null && this.lastTypefaceName.equals(name)) {
                return this.lastTypeface;
            }
        }
        ITypeface tf = this.backend.getNativeTypeface(name);
        if (tf == null) {
            return null;
        }
        NativeFontCache nativeFontCache2 = this;
        synchronized (nativeFontCache2) {
            this.lastTypeface = tf;
            this.lastTypefaceName = name;
        }
        return tf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFixedSizeFont getDefaultNativeFont(int size, int style) {
        ITypeface gdt;
        NativeFontCache nativeFontCache = this;
        synchronized (nativeFontCache) {
            if (this.lastDefaultFont != null && this.lastDefaultFontSize == size && this.lastDefaultFontStyle == style) {
                return this.lastDefaultFont;
            }
        }
        NativeFontCache nativeFontCache2 = this;
        synchronized (nativeFontCache2) {
            if (this.defaultTypeface == null) {
                this.defaultTypeface = this.backend.getDefaultTypeface();
            }
            gdt = this.defaultTypeface;
        }
        IFixedSizeFont res = gdt.derive(size, style);
        NativeFontCache nativeFontCache3 = this;
        synchronized (nativeFontCache3) {
            this.lastDefaultFontSize = size;
            this.lastDefaultFontStyle = style;
            this.lastDefaultFont = res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFixedSizeFont getNativeFont(int size, int style, String name) {
        NativeFontCache nativeFontCache = this;
        synchronized (nativeFontCache) {
            if (this.lastFont != null && this.lastFontSize == size && this.lastFontStyle == style && this.lastFontName.equals(name)) {
                return this.lastFont;
            }
        }
        ITypeface tf = this.getTypeface(name);
        if (tf == null) {
            return null;
        }
        IFixedSizeFont res = tf.derive(size, style);
        NativeFontCache nativeFontCache2 = this;
        synchronized (nativeFontCache2) {
            this.lastFontName = name;
            this.lastFontSize = size;
            this.lastFontStyle = style;
            this.lastFont = res;
        }
        return res;
    }
}

