/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.render.IImage;
import gabien.render.WSIImage;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.jdt.annotation.Nullable;

public final class ImageCache {
    private HashMap<String, WSIImage> loadedWSIImages = new HashMap();
    private HashMap<String, IImage> loadedImages = new HashMap();
    private final IGaBIEn backend;

    public ImageCache(IGaBIEn backend) {
        this.backend = backend;
        GaBIEn.verify(backend);
    }

    @Nullable
    public WSIImage getWSIImage(String a, boolean res) {
        String ki = a + (res ? (char)'R' : 'F');
        if (this.loadedWSIImages.containsKey(ki)) {
            return this.loadedWSIImages.get(ki);
        }
        InputStream ip = res ? GaBIEn.getResource(a) : GaBIEn.getInFile(a);
        WSIImage img = ip != null ? this.backend.decodeWSIImage(ip) : null;
        this.loadedWSIImages.put(ki, img);
        return img;
    }

    public IImage getImage(String a, boolean res) {
        String ki = a + "_N_N_N" + (res ? (char)'R' : 'F');
        if (this.loadedImages.containsKey(ki)) {
            return this.loadedImages.get(ki);
        }
        WSIImage img = this.getWSIImage(a, res);
        IImage resImg = img == null ? GaBIEn.getErrorImage() : img.upload("ImageCache:" + ki);
        this.loadedImages.put(ki, resImg);
        return resImg;
    }

    public IImage getImageCK(String a, boolean res, int tr, int tg, int tb) {
        String ki = a + "_" + tr + "_" + tg + "_" + tb + (res ? (char)'R' : 'F');
        if (this.loadedImages.containsKey(ki)) {
            return this.loadedImages.get(ki);
        }
        WSIImage img = this.getWSIImage(a, res);
        IImage resImg = img == null ? GaBIEn.getErrorImage() : GaBIEn.wsiToCK("ImageCache:" + ki, img, tr, tg, tb);
        this.loadedImages.put(ki, resImg);
        return resImg;
    }

    public void hintFlushAllTheCaches() {
        this.loadedImages.clear();
        this.loadedWSIImages.clear();
    }
}

