/*
 * Decompiled with CFR 0.152.
 */
package gabien.backend;

import gabien.GaBIEn;
import gabien.backend.IGaBIEn;
import gabien.backend.IGaBIEnFileBrowser;
import gabien.backend.UIFileBrowser;
import gabien.ui.UIElement;
import gabien.ui.WindowCreatingUIElementConsumer;
import gabien.wsi.WindowSpecs;
import java.util.function.Consumer;

public class EmulatedFileBrowser
implements IGaBIEnFileBrowser {
    public String browserDirectory;
    private final IGaBIEn backend;

    public EmulatedFileBrowser(IGaBIEn backend) {
        this.backend = backend;
        this.setBrowserDirectory(".");
    }

    @Override
    public void setBrowserDirectory(String s) {
        this.browserDirectory = GaBIEn.absolutePathOf(s);
    }

    @Override
    public void startFileBrowser(String text, boolean saving, String exts, Consumer<String> result, String initialName) {
        final WindowCreatingUIElementConsumer wc = new WindowCreatingUIElementConsumer(){

            @Override
            protected WindowSpecs setupSpecs(UIElement o, int scale, boolean fullscreen, boolean resizable) {
                WindowSpecs ws = super.setupSpecs(o, scale, fullscreen, resizable);
                ws.engineElevateToSystemPriority(EmulatedFileBrowser.this.backend);
                return ws;
            }
        };
        UIFileBrowser fb = new UIFileBrowser(this.browserDirectory, result, text, saving, GaBIEn.sysCoreFontSize, GaBIEn.sysCoreFontSize, initialName);
        wc.accept(fb);
        Runnable tick = new Runnable(){
            double lastTime = GaBIEn.getTime();

            @Override
            public void run() {
                double newTime = GaBIEn.getTime();
                double dT = newTime - this.lastTime;
                this.lastTime = newTime;
                wc.runTick(dT);
                if (wc.runningWindows().size() > 0) {
                    GaBIEn.pushLaterCallback(this);
                }
            }
        };
        GaBIEn.pushCallback(tick);
    }
}

